package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMetricRuleBlackList invokes the cms.CreateMetricRuleBlackList API synchronously
func (client *Client) CreateMetricRuleBlackList(request *CreateMetricRuleBlackListRequest) (response *CreateMetricRuleBlackListResponse, err error) {
	response = CreateCreateMetricRuleBlackListResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMetricRuleBlackListWithChan invokes the cms.CreateMetricRuleBlackList API asynchronously
func (client *Client) CreateMetricRuleBlackListWithChan(request *CreateMetricRuleBlackListRequest) (<-chan *CreateMetricRuleBlackListResponse, <-chan error) {
	responseChan := make(chan *CreateMetricRuleBlackListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMetricRuleBlackList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMetricRuleBlackListWithCallback invokes the cms.CreateMetricRuleBlackList API asynchronously
func (client *Client) CreateMetricRuleBlackListWithCallback(request *CreateMetricRuleBlackListRequest, callback func(response *CreateMetricRuleBlackListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMetricRuleBlackListResponse
		var err error
		defer close(result)
		response, err = client.CreateMetricRuleBlackList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMetricRuleBlackListRequest is the request struct for api CreateMetricRuleBlackList
type CreateMetricRuleBlackListRequest struct {
	*requests.RpcRequest
	ScopeType       string                              `position:"Query" name:"ScopeType"`
	Instances       *[]string                           `position:"Query" name:"Instances"  type:"Repeated"`
	EnableEndTime   string                              `position:"Query" name:"EnableEndTime"`
	ScopeValue      string                              `position:"Query" name:"ScopeValue"`
	EnableStartTime string                              `position:"Query" name:"EnableStartTime"`
	EffectiveTime   string                              `position:"Query" name:"EffectiveTime"`
	Name            string                              `position:"Query" name:"Name"`
	Namespace       string                              `position:"Query" name:"Namespace"`
	Metrics         *[]CreateMetricRuleBlackListMetrics `position:"Query" name:"Metrics"  type:"Repeated"`
	Category        string                              `position:"Query" name:"Category"`
}

// CreateMetricRuleBlackListMetrics is a repeated param struct in CreateMetricRuleBlackListRequest
type CreateMetricRuleBlackListMetrics struct {
	Resource   string `name:"Resource"`
	MetricName string `name:"MetricName"`
}

// CreateMetricRuleBlackListResponse is the response struct for api CreateMetricRuleBlackList
type CreateMetricRuleBlackListResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateCreateMetricRuleBlackListRequest creates a request to invoke CreateMetricRuleBlackList API
func CreateCreateMetricRuleBlackListRequest() (request *CreateMetricRuleBlackListRequest) {
	request = &CreateMetricRuleBlackListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "CreateMetricRuleBlackList", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateMetricRuleBlackListResponse creates a response to parse from CreateMetricRuleBlackList response
func CreateCreateMetricRuleBlackListResponse() (response *CreateMetricRuleBlackListResponse) {
	response = &CreateMetricRuleBlackListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
