package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyVpcFirewallCenConfigure invokes the cloudfw.ModifyVpcFirewallCenConfigure API synchronously
func (client *Client) ModifyVpcFirewallCenConfigure(request *ModifyVpcFirewallCenConfigureRequest) (response *ModifyVpcFirewallCenConfigureResponse, err error) {
	response = CreateModifyVpcFirewallCenConfigureResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyVpcFirewallCenConfigureWithChan invokes the cloudfw.ModifyVpcFirewallCenConfigure API asynchronously
func (client *Client) ModifyVpcFirewallCenConfigureWithChan(request *ModifyVpcFirewallCenConfigureRequest) (<-chan *ModifyVpcFirewallCenConfigureResponse, <-chan error) {
	responseChan := make(chan *ModifyVpcFirewallCenConfigureResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyVpcFirewallCenConfigure(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyVpcFirewallCenConfigureWithCallback invokes the cloudfw.ModifyVpcFirewallCenConfigure API asynchronously
func (client *Client) ModifyVpcFirewallCenConfigureWithCallback(request *ModifyVpcFirewallCenConfigureRequest, callback func(response *ModifyVpcFirewallCenConfigureResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyVpcFirewallCenConfigureResponse
		var err error
		defer close(result)
		response, err = client.ModifyVpcFirewallCenConfigure(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyVpcFirewallCenConfigureRequest is the request struct for api ModifyVpcFirewallCenConfigure
type ModifyVpcFirewallCenConfigureRequest struct {
	*requests.RpcRequest
	VpcFirewallName string `position:"Query" name:"VpcFirewallName"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	MemberUid       string `position:"Query" name:"MemberUid"`
	Lang            string `position:"Query" name:"Lang"`
	VpcFirewallId   string `position:"Query" name:"VpcFirewallId"`
}

// ModifyVpcFirewallCenConfigureResponse is the response struct for api ModifyVpcFirewallCenConfigure
type ModifyVpcFirewallCenConfigureResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyVpcFirewallCenConfigureRequest creates a request to invoke ModifyVpcFirewallCenConfigure API
func CreateModifyVpcFirewallCenConfigureRequest() (request *ModifyVpcFirewallCenConfigureRequest) {
	request = &ModifyVpcFirewallCenConfigureRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "ModifyVpcFirewallCenConfigure", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyVpcFirewallCenConfigureResponse creates a response to parse from ModifyVpcFirewallCenConfigure response
func CreateModifyVpcFirewallCenConfigureResponse() (response *ModifyVpcFirewallCenConfigureResponse) {
	response = &ModifyVpcFirewallCenConfigureResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
