package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyTrFirewallV2Configuration invokes the cloudfw.ModifyTrFirewallV2Configuration API synchronously
func (client *Client) ModifyTrFirewallV2Configuration(request *ModifyTrFirewallV2ConfigurationRequest) (response *ModifyTrFirewallV2ConfigurationResponse, err error) {
	response = CreateModifyTrFirewallV2ConfigurationResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyTrFirewallV2ConfigurationWithChan invokes the cloudfw.ModifyTrFirewallV2Configuration API asynchronously
func (client *Client) ModifyTrFirewallV2ConfigurationWithChan(request *ModifyTrFirewallV2ConfigurationRequest) (<-chan *ModifyTrFirewallV2ConfigurationResponse, <-chan error) {
	responseChan := make(chan *ModifyTrFirewallV2ConfigurationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyTrFirewallV2Configuration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyTrFirewallV2ConfigurationWithCallback invokes the cloudfw.ModifyTrFirewallV2Configuration API asynchronously
func (client *Client) ModifyTrFirewallV2ConfigurationWithCallback(request *ModifyTrFirewallV2ConfigurationRequest, callback func(response *ModifyTrFirewallV2ConfigurationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyTrFirewallV2ConfigurationResponse
		var err error
		defer close(result)
		response, err = client.ModifyTrFirewallV2Configuration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyTrFirewallV2ConfigurationRequest is the request struct for api ModifyTrFirewallV2Configuration
type ModifyTrFirewallV2ConfigurationRequest struct {
	*requests.RpcRequest
	FirewallId   string `position:"Query" name:"FirewallId"`
	SourceIp     string `position:"Query" name:"SourceIp"`
	Lang         string `position:"Query" name:"Lang"`
	FirewallName string `position:"Query" name:"FirewallName"`
}

// ModifyTrFirewallV2ConfigurationResponse is the response struct for api ModifyTrFirewallV2Configuration
type ModifyTrFirewallV2ConfigurationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyTrFirewallV2ConfigurationRequest creates a request to invoke ModifyTrFirewallV2Configuration API
func CreateModifyTrFirewallV2ConfigurationRequest() (request *ModifyTrFirewallV2ConfigurationRequest) {
	request = &ModifyTrFirewallV2ConfigurationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "ModifyTrFirewallV2Configuration", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyTrFirewallV2ConfigurationResponse creates a response to parse from ModifyTrFirewallV2Configuration response
func CreateModifyTrFirewallV2ConfigurationResponse() (response *ModifyTrFirewallV2ConfigurationResponse) {
	response = &ModifyTrFirewallV2ConfigurationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
