package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeNatFirewallPolicyPriorUsed invokes the cloudfw.DescribeNatFirewallPolicyPriorUsed API synchronously
func (client *Client) DescribeNatFirewallPolicyPriorUsed(request *DescribeNatFirewallPolicyPriorUsedRequest) (response *DescribeNatFirewallPolicyPriorUsedResponse, err error) {
	response = CreateDescribeNatFirewallPolicyPriorUsedResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeNatFirewallPolicyPriorUsedWithChan invokes the cloudfw.DescribeNatFirewallPolicyPriorUsed API asynchronously
func (client *Client) DescribeNatFirewallPolicyPriorUsedWithChan(request *DescribeNatFirewallPolicyPriorUsedRequest) (<-chan *DescribeNatFirewallPolicyPriorUsedResponse, <-chan error) {
	responseChan := make(chan *DescribeNatFirewallPolicyPriorUsedResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeNatFirewallPolicyPriorUsed(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeNatFirewallPolicyPriorUsedWithCallback invokes the cloudfw.DescribeNatFirewallPolicyPriorUsed API asynchronously
func (client *Client) DescribeNatFirewallPolicyPriorUsedWithCallback(request *DescribeNatFirewallPolicyPriorUsedRequest, callback func(response *DescribeNatFirewallPolicyPriorUsedResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeNatFirewallPolicyPriorUsedResponse
		var err error
		defer close(result)
		response, err = client.DescribeNatFirewallPolicyPriorUsed(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeNatFirewallPolicyPriorUsedRequest is the request struct for api DescribeNatFirewallPolicyPriorUsed
type DescribeNatFirewallPolicyPriorUsedRequest struct {
	*requests.RpcRequest
	SourceIp     string `position:"Query" name:"SourceIp"`
	NatGatewayId string `position:"Query" name:"NatGatewayId"`
	IpVersion    string `position:"Query" name:"IpVersion"`
	Lang         string `position:"Query" name:"Lang"`
	Direction    string `position:"Query" name:"Direction"`
}

// DescribeNatFirewallPolicyPriorUsedResponse is the response struct for api DescribeNatFirewallPolicyPriorUsed
type DescribeNatFirewallPolicyPriorUsedResponse struct {
	*responses.BaseResponse
	End       int    `json:"End" xml:"End"`
	Start     int    `json:"Start" xml:"Start"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeNatFirewallPolicyPriorUsedRequest creates a request to invoke DescribeNatFirewallPolicyPriorUsed API
func CreateDescribeNatFirewallPolicyPriorUsedRequest() (request *DescribeNatFirewallPolicyPriorUsedRequest) {
	request = &DescribeNatFirewallPolicyPriorUsedRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DescribeNatFirewallPolicyPriorUsed", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeNatFirewallPolicyPriorUsedResponse creates a response to parse from DescribeNatFirewallPolicyPriorUsed response
func CreateDescribeNatFirewallPolicyPriorUsedResponse() (response *DescribeNatFirewallPolicyPriorUsedResponse) {
	response = &DescribeNatFirewallPolicyPriorUsedResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
