package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAssetList invokes the cloudfw.DescribeAssetList API synchronously
func (client *Client) DescribeAssetList(request *DescribeAssetListRequest) (response *DescribeAssetListResponse, err error) {
	response = CreateDescribeAssetListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAssetListWithChan invokes the cloudfw.DescribeAssetList API asynchronously
func (client *Client) DescribeAssetListWithChan(request *DescribeAssetListRequest) (<-chan *DescribeAssetListResponse, <-chan error) {
	responseChan := make(chan *DescribeAssetListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAssetList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAssetListWithCallback invokes the cloudfw.DescribeAssetList API asynchronously
func (client *Client) DescribeAssetListWithCallback(request *DescribeAssetListRequest, callback func(response *DescribeAssetListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAssetListResponse
		var err error
		defer close(result)
		response, err = client.DescribeAssetList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAssetListRequest is the request struct for api DescribeAssetList
type DescribeAssetListRequest struct {
	*requests.RpcRequest
	SearchItem     string           `position:"Query" name:"SearchItem"`
	NewResourceTag string           `position:"Query" name:"NewResourceTag"`
	Type           string           `position:"Query" name:"Type"`
	SgStatus       string           `position:"Query" name:"SgStatus"`
	SourceIp       string           `position:"Query" name:"SourceIp"`
	PageSize       string           `position:"Query" name:"PageSize"`
	IpVersion      string           `position:"Query" name:"IpVersion"`
	Lang           string           `position:"Query" name:"Lang"`
	UserType       string           `position:"Query" name:"UserType"`
	CurrentPage    string           `position:"Query" name:"CurrentPage"`
	ResourceType   string           `position:"Query" name:"ResourceType"`
	RegionNo       string           `position:"Query" name:"RegionNo"`
	MemberUid      requests.Integer `position:"Query" name:"MemberUid"`
	Status         string           `position:"Query" name:"Status"`
}

// DescribeAssetListResponse is the response struct for api DescribeAssetList
type DescribeAssetListResponse struct {
	*responses.BaseResponse
	TotalCount int        `json:"TotalCount" xml:"TotalCount"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Assets     []Resource `json:"Assets" xml:"Assets"`
}

// CreateDescribeAssetListRequest creates a request to invoke DescribeAssetList API
func CreateDescribeAssetListRequest() (request *DescribeAssetListRequest) {
	request = &DescribeAssetListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DescribeAssetList", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAssetListResponse creates a response to parse from DescribeAssetList response
func CreateDescribeAssetListResponse() (response *DescribeAssetListResponse) {
	response = &DescribeAssetListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
