package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteVpcFirewallCenConfigure invokes the cloudfw.DeleteVpcFirewallCenConfigure API synchronously
func (client *Client) DeleteVpcFirewallCenConfigure(request *DeleteVpcFirewallCenConfigureRequest) (response *DeleteVpcFirewallCenConfigureResponse, err error) {
	response = CreateDeleteVpcFirewallCenConfigureResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteVpcFirewallCenConfigureWithChan invokes the cloudfw.DeleteVpcFirewallCenConfigure API asynchronously
func (client *Client) DeleteVpcFirewallCenConfigureWithChan(request *DeleteVpcFirewallCenConfigureRequest) (<-chan *DeleteVpcFirewallCenConfigureResponse, <-chan error) {
	responseChan := make(chan *DeleteVpcFirewallCenConfigureResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteVpcFirewallCenConfigure(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteVpcFirewallCenConfigureWithCallback invokes the cloudfw.DeleteVpcFirewallCenConfigure API asynchronously
func (client *Client) DeleteVpcFirewallCenConfigureWithCallback(request *DeleteVpcFirewallCenConfigureRequest, callback func(response *DeleteVpcFirewallCenConfigureResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteVpcFirewallCenConfigureResponse
		var err error
		defer close(result)
		response, err = client.DeleteVpcFirewallCenConfigure(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteVpcFirewallCenConfigureRequest is the request struct for api DeleteVpcFirewallCenConfigure
type DeleteVpcFirewallCenConfigureRequest struct {
	*requests.RpcRequest
	SourceIp          string    `position:"Query" name:"SourceIp"`
	MemberUid         string    `position:"Query" name:"MemberUid"`
	VpcFirewallIdList *[]string `position:"Query" name:"VpcFirewallIdList"  type:"Repeated"`
	Lang              string    `position:"Query" name:"Lang"`
}

// DeleteVpcFirewallCenConfigureResponse is the response struct for api DeleteVpcFirewallCenConfigure
type DeleteVpcFirewallCenConfigureResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteVpcFirewallCenConfigureRequest creates a request to invoke DeleteVpcFirewallCenConfigure API
func CreateDeleteVpcFirewallCenConfigureRequest() (request *DeleteVpcFirewallCenConfigureRequest) {
	request = &DeleteVpcFirewallCenConfigureRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DeleteVpcFirewallCenConfigure", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteVpcFirewallCenConfigureResponse creates a response to parse from DeleteVpcFirewallCenConfigure response
func CreateDeleteVpcFirewallCenConfigureResponse() (response *DeleteVpcFirewallCenConfigureResponse) {
	response = &DeleteVpcFirewallCenConfigureResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
