package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCabInstance invokes the cloudcallcenter.DeleteCabInstance API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/deletecabinstance.html
func (client *Client) DeleteCabInstance(request *DeleteCabInstanceRequest) (response *DeleteCabInstanceResponse, err error) {
	response = CreateDeleteCabInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCabInstanceWithChan invokes the cloudcallcenter.DeleteCabInstance API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/deletecabinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteCabInstanceWithChan(request *DeleteCabInstanceRequest) (<-chan *DeleteCabInstanceResponse, <-chan error) {
	responseChan := make(chan *DeleteCabInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCabInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCabInstanceWithCallback invokes the cloudcallcenter.DeleteCabInstance API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/deletecabinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteCabInstanceWithCallback(request *DeleteCabInstanceRequest, callback func(response *DeleteCabInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCabInstanceResponse
		var err error
		defer close(result)
		response, err = client.DeleteCabInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCabInstanceRequest is the request struct for api DeleteCabInstance
type DeleteCabInstanceRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DeleteCabInstanceResponse is the response struct for api DeleteCabInstance
type DeleteCabInstanceResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateDeleteCabInstanceRequest creates a request to invoke DeleteCabInstance API
func CreateDeleteCabInstanceRequest() (request *DeleteCabInstanceRequest) {
	request = &DeleteCabInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "DeleteCabInstance", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteCabInstanceResponse creates a response to parse from DeleteCabInstance response
func CreateDeleteCabInstanceResponse() (response *DeleteCabInstanceResponse) {
	response = &DeleteCabInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
