package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Id2MetaStandardVerify invokes the cloudauth.Id2MetaStandardVerify API synchronously
func (client *Client) Id2MetaStandardVerify(request *Id2MetaStandardVerifyRequest) (response *Id2MetaStandardVerifyResponse, err error) {
	response = CreateId2MetaStandardVerifyResponse()
	err = client.DoAction(request, response)
	return
}

// Id2MetaStandardVerifyWithChan invokes the cloudauth.Id2MetaStandardVerify API asynchronously
func (client *Client) Id2MetaStandardVerifyWithChan(request *Id2MetaStandardVerifyRequest) (<-chan *Id2MetaStandardVerifyResponse, <-chan error) {
	responseChan := make(chan *Id2MetaStandardVerifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Id2MetaStandardVerify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// Id2MetaStandardVerifyWithCallback invokes the cloudauth.Id2MetaStandardVerify API asynchronously
func (client *Client) Id2MetaStandardVerifyWithCallback(request *Id2MetaStandardVerifyRequest, callback func(response *Id2MetaStandardVerifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *Id2MetaStandardVerifyResponse
		var err error
		defer close(result)
		response, err = client.Id2MetaStandardVerify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// Id2MetaStandardVerifyRequest is the request struct for api Id2MetaStandardVerify
type Id2MetaStandardVerifyRequest struct {
	*requests.RpcRequest
	ParamType   string `position:"Body" name:"ParamType"`
	IdentifyNum string `position:"Body" name:"IdentifyNum"`
	UserName    string `position:"Body" name:"UserName"`
}

// Id2MetaStandardVerifyResponse is the response struct for api Id2MetaStandardVerify
type Id2MetaStandardVerifyResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Code         string       `json:"Code" xml:"Code"`
	Message      string       `json:"Message" xml:"Message"`
	ResultObject ResultObject `json:"ResultObject" xml:"ResultObject"`
}

// CreateId2MetaStandardVerifyRequest creates a request to invoke Id2MetaStandardVerify API
func CreateId2MetaStandardVerifyRequest() (request *Id2MetaStandardVerifyRequest) {
	request = &Id2MetaStandardVerifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "Id2MetaStandardVerify", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateId2MetaStandardVerifyResponse creates a response to parse from Id2MetaStandardVerify response
func CreateId2MetaStandardVerifyResponse() (response *Id2MetaStandardVerifyResponse) {
	response = &Id2MetaStandardVerifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
