package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceNewConnections invokes the cloudapi.DescribeInstanceNewConnections API synchronously
func (client *Client) DescribeInstanceNewConnections(request *DescribeInstanceNewConnectionsRequest) (response *DescribeInstanceNewConnectionsResponse, err error) {
	response = CreateDescribeInstanceNewConnectionsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceNewConnectionsWithChan invokes the cloudapi.DescribeInstanceNewConnections API asynchronously
func (client *Client) DescribeInstanceNewConnectionsWithChan(request *DescribeInstanceNewConnectionsRequest) (<-chan *DescribeInstanceNewConnectionsResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceNewConnectionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceNewConnections(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceNewConnectionsWithCallback invokes the cloudapi.DescribeInstanceNewConnections API asynchronously
func (client *Client) DescribeInstanceNewConnectionsWithCallback(request *DescribeInstanceNewConnectionsRequest, callback func(response *DescribeInstanceNewConnectionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceNewConnectionsResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceNewConnections(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceNewConnectionsRequest is the request struct for api DescribeInstanceNewConnections
type DescribeInstanceNewConnectionsRequest struct {
	*requests.RpcRequest
	EndTime       string `position:"Query" name:"EndTime"`
	StartTime     string `position:"Query" name:"StartTime"`
	SbcName       string `position:"Query" name:"SbcName"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
}

// DescribeInstanceNewConnectionsResponse is the response struct for api DescribeInstanceNewConnections
type DescribeInstanceNewConnectionsResponse struct {
	*responses.BaseResponse
	RequestId              string                 `json:"RequestId" xml:"RequestId"`
	InstanceNewConnections InstanceNewConnections `json:"InstanceNewConnections" xml:"InstanceNewConnections"`
}

// CreateDescribeInstanceNewConnectionsRequest creates a request to invoke DescribeInstanceNewConnections API
func CreateDescribeInstanceNewConnectionsRequest() (request *DescribeInstanceNewConnectionsRequest) {
	request = &DescribeInstanceNewConnectionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribeInstanceNewConnections", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceNewConnectionsResponse creates a response to parse from DescribeInstanceNewConnections response
func CreateDescribeInstanceNewConnectionsResponse() (response *DescribeInstanceNewConnectionsResponse) {
	response = &DescribeInstanceNewConnectionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
