package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWafScope invokes the cloud_siem.DescribeWafScope API synchronously
func (client *Client) DescribeWafScope(request *DescribeWafScopeRequest) (response *DescribeWafScopeResponse, err error) {
	response = CreateDescribeWafScopeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWafScopeWithChan invokes the cloud_siem.DescribeWafScope API asynchronously
func (client *Client) DescribeWafScopeWithChan(request *DescribeWafScopeRequest) (<-chan *DescribeWafScopeResponse, <-chan error) {
	responseChan := make(chan *DescribeWafScopeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWafScope(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWafScopeWithCallback invokes the cloud_siem.DescribeWafScope API asynchronously
func (client *Client) DescribeWafScopeWithCallback(request *DescribeWafScopeRequest, callback func(response *DescribeWafScopeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWafScopeResponse
		var err error
		defer close(result)
		response, err = client.DescribeWafScope(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWafScopeRequest is the request struct for api DescribeWafScope
type DescribeWafScopeRequest struct {
	*requests.RpcRequest
	EntityId requests.Integer `position:"Body" name:"EntityId"`
}

// DescribeWafScopeResponse is the response struct for api DescribeWafScope
type DescribeWafScopeResponse struct {
	*responses.BaseResponse
	Success   bool       `json:"Success" xml:"Success"`
	Code      int        `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeWafScopeRequest creates a request to invoke DescribeWafScope API
func CreateDescribeWafScopeRequest() (request *DescribeWafScopeRequest) {
	request = &DescribeWafScopeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DescribeWafScope", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeWafScopeResponse creates a response to parse from DescribeWafScope response
func CreateDescribeWafScopeResponse() (response *DescribeWafScopeResponse) {
	response = &DescribeWafScopeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
