package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCdnUserDomainsByFunc invokes the cdn.DescribeCdnUserDomainsByFunc API synchronously
func (client *Client) DescribeCdnUserDomainsByFunc(request *DescribeCdnUserDomainsByFuncRequest) (response *DescribeCdnUserDomainsByFuncResponse, err error) {
	response = CreateDescribeCdnUserDomainsByFuncResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCdnUserDomainsByFuncWithChan invokes the cdn.DescribeCdnUserDomainsByFunc API asynchronously
func (client *Client) DescribeCdnUserDomainsByFuncWithChan(request *DescribeCdnUserDomainsByFuncRequest) (<-chan *DescribeCdnUserDomainsByFuncResponse, <-chan error) {
	responseChan := make(chan *DescribeCdnUserDomainsByFuncResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCdnUserDomainsByFunc(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCdnUserDomainsByFuncWithCallback invokes the cdn.DescribeCdnUserDomainsByFunc API asynchronously
func (client *Client) DescribeCdnUserDomainsByFuncWithCallback(request *DescribeCdnUserDomainsByFuncRequest, callback func(response *DescribeCdnUserDomainsByFuncResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCdnUserDomainsByFuncResponse
		var err error
		defer close(result)
		response, err = client.DescribeCdnUserDomainsByFunc(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCdnUserDomainsByFuncRequest is the request struct for api DescribeCdnUserDomainsByFunc
type DescribeCdnUserDomainsByFuncRequest struct {
	*requests.RpcRequest
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	FuncId          requests.Integer `position:"Query" name:"FuncId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeCdnUserDomainsByFuncResponse is the response struct for api DescribeCdnUserDomainsByFunc
type DescribeCdnUserDomainsByFuncResponse struct {
	*responses.BaseResponse
	RequestId  string                                `json:"RequestId" xml:"RequestId"`
	PageNumber int64                                 `json:"PageNumber" xml:"PageNumber"`
	PageSize   int64                                 `json:"PageSize" xml:"PageSize"`
	TotalCount int64                                 `json:"TotalCount" xml:"TotalCount"`
	Domains    DomainsInDescribeCdnUserDomainsByFunc `json:"Domains" xml:"Domains"`
}

// CreateDescribeCdnUserDomainsByFuncRequest creates a request to invoke DescribeCdnUserDomainsByFunc API
func CreateDescribeCdnUserDomainsByFuncRequest() (request *DescribeCdnUserDomainsByFuncRequest) {
	request = &DescribeCdnUserDomainsByFuncRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeCdnUserDomainsByFunc", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeCdnUserDomainsByFuncResponse creates a response to parse from DescribeCdnUserDomainsByFunc response
func CreateDescribeCdnUserDomainsByFuncResponse() (response *DescribeCdnUserDomainsByFuncResponse) {
	response = &DescribeCdnUserDomainsByFuncResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
