package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PublishContactFlow invokes the ccc.PublishContactFlow API synchronously
func (client *Client) PublishContactFlow(request *PublishContactFlowRequest) (response *PublishContactFlowResponse, err error) {
	response = CreatePublishContactFlowResponse()
	err = client.DoAction(request, response)
	return
}

// PublishContactFlowWithChan invokes the ccc.PublishContactFlow API asynchronously
func (client *Client) PublishContactFlowWithChan(request *PublishContactFlowRequest) (<-chan *PublishContactFlowResponse, <-chan error) {
	responseChan := make(chan *PublishContactFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PublishContactFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PublishContactFlowWithCallback invokes the ccc.PublishContactFlow API asynchronously
func (client *Client) PublishContactFlowWithCallback(request *PublishContactFlowRequest, callback func(response *PublishContactFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PublishContactFlowResponse
		var err error
		defer close(result)
		response, err = client.PublishContactFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PublishContactFlowRequest is the request struct for api PublishContactFlow
type PublishContactFlowRequest struct {
	*requests.RpcRequest
	ContactFlowId string `position:"Query" name:"ContactFlowId"`
	DraftId       string `position:"Query" name:"DraftId"`
	InstanceId    string `position:"Query" name:"InstanceId"`
}

// PublishContactFlowResponse is the response struct for api PublishContactFlow
type PublishContactFlowResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreatePublishContactFlowRequest creates a request to invoke PublishContactFlow API
func CreatePublishContactFlowRequest() (request *PublishContactFlowRequest) {
	request = &PublishContactFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "PublishContactFlow", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePublishContactFlowResponse creates a response to parse from PublishContactFlow response
func CreatePublishContactFlowResponse() (response *PublishContactFlowResponse) {
	response = &PublishContactFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
