package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAudioFileUploadParameters invokes the ccc.GetAudioFileUploadParameters API synchronously
func (client *Client) GetAudioFileUploadParameters(request *GetAudioFileUploadParametersRequest) (response *GetAudioFileUploadParametersResponse, err error) {
	response = CreateGetAudioFileUploadParametersResponse()
	err = client.DoAction(request, response)
	return
}

// GetAudioFileUploadParametersWithChan invokes the ccc.GetAudioFileUploadParameters API asynchronously
func (client *Client) GetAudioFileUploadParametersWithChan(request *GetAudioFileUploadParametersRequest) (<-chan *GetAudioFileUploadParametersResponse, <-chan error) {
	responseChan := make(chan *GetAudioFileUploadParametersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAudioFileUploadParameters(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAudioFileUploadParametersWithCallback invokes the ccc.GetAudioFileUploadParameters API asynchronously
func (client *Client) GetAudioFileUploadParametersWithCallback(request *GetAudioFileUploadParametersRequest, callback func(response *GetAudioFileUploadParametersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAudioFileUploadParametersResponse
		var err error
		defer close(result)
		response, err = client.GetAudioFileUploadParameters(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAudioFileUploadParametersRequest is the request struct for api GetAudioFileUploadParameters
type GetAudioFileUploadParametersRequest struct {
	*requests.RpcRequest
	InstanceId    string `position:"Query" name:"InstanceId"`
	AudioFileName string `position:"Query" name:"AudioFileName"`
}

// GetAudioFileUploadParametersResponse is the response struct for api GetAudioFileUploadParameters
type GetAudioFileUploadParametersResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetAudioFileUploadParametersRequest creates a request to invoke GetAudioFileUploadParameters API
func CreateGetAudioFileUploadParametersRequest() (request *GetAudioFileUploadParametersRequest) {
	request = &GetAudioFileUploadParametersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "GetAudioFileUploadParameters", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetAudioFileUploadParametersResponse creates a response to parse from GetAudioFileUploadParameters response
func CreateGetAudioFileUploadParametersResponse() (response *GetAudioFileUploadParametersResponse) {
	response = &GetAudioFileUploadParametersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
