package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateGroupAuthorizationRule invokes the cc5g.UpdateGroupAuthorizationRule API synchronously
func (client *Client) UpdateGroupAuthorizationRule(request *UpdateGroupAuthorizationRuleRequest) (response *UpdateGroupAuthorizationRuleResponse, err error) {
	response = CreateUpdateGroupAuthorizationRuleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateGroupAuthorizationRuleWithChan invokes the cc5g.UpdateGroupAuthorizationRule API asynchronously
func (client *Client) UpdateGroupAuthorizationRuleWithChan(request *UpdateGroupAuthorizationRuleRequest) (<-chan *UpdateGroupAuthorizationRuleResponse, <-chan error) {
	responseChan := make(chan *UpdateGroupAuthorizationRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateGroupAuthorizationRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateGroupAuthorizationRuleWithCallback invokes the cc5g.UpdateGroupAuthorizationRule API asynchronously
func (client *Client) UpdateGroupAuthorizationRuleWithCallback(request *UpdateGroupAuthorizationRuleRequest, callback func(response *UpdateGroupAuthorizationRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateGroupAuthorizationRuleResponse
		var err error
		defer close(result)
		response, err = client.UpdateGroupAuthorizationRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateGroupAuthorizationRuleRequest is the request struct for api UpdateGroupAuthorizationRule
type UpdateGroupAuthorizationRuleRequest struct {
	*requests.RpcRequest
	WirelessCloudConnectorGroupId string           `position:"Query" name:"WirelessCloudConnectorGroupId"`
	ClientToken                   string           `position:"Query" name:"ClientToken"`
	SourceCidr                    string           `position:"Query" name:"SourceCidr"`
	Destination                   string           `position:"Query" name:"Destination"`
	Description                   string           `position:"Query" name:"Description"`
	Protocol                      string           `position:"Query" name:"Protocol"`
	Policy                        string           `position:"Query" name:"Policy"`
	DryRun                        requests.Boolean `position:"Query" name:"DryRun"`
	AuthorizationRuleId           string           `position:"Query" name:"AuthorizationRuleId"`
	DestinationPort               string           `position:"Query" name:"DestinationPort"`
	Name                          string           `position:"Query" name:"Name"`
}

// UpdateGroupAuthorizationRuleResponse is the response struct for api UpdateGroupAuthorizationRule
type UpdateGroupAuthorizationRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateGroupAuthorizationRuleRequest creates a request to invoke UpdateGroupAuthorizationRule API
func CreateUpdateGroupAuthorizationRuleRequest() (request *UpdateGroupAuthorizationRuleRequest) {
	request = &UpdateGroupAuthorizationRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "UpdateGroupAuthorizationRule", "fivegcc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateGroupAuthorizationRuleResponse creates a response to parse from UpdateGroupAuthorizationRule response
func CreateUpdateGroupAuthorizationRuleResponse() (response *UpdateGroupAuthorizationRuleResponse) {
	response = &UpdateGroupAuthorizationRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
