package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTransitRouterEcrAttachmentAttribute invokes the cbn.UpdateTransitRouterEcrAttachmentAttribute API synchronously
func (client *Client) UpdateTransitRouterEcrAttachmentAttribute(request *UpdateTransitRouterEcrAttachmentAttributeRequest) (response *UpdateTransitRouterEcrAttachmentAttributeResponse, err error) {
	response = CreateUpdateTransitRouterEcrAttachmentAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTransitRouterEcrAttachmentAttributeWithChan invokes the cbn.UpdateTransitRouterEcrAttachmentAttribute API asynchronously
func (client *Client) UpdateTransitRouterEcrAttachmentAttributeWithChan(request *UpdateTransitRouterEcrAttachmentAttributeRequest) (<-chan *UpdateTransitRouterEcrAttachmentAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateTransitRouterEcrAttachmentAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTransitRouterEcrAttachmentAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTransitRouterEcrAttachmentAttributeWithCallback invokes the cbn.UpdateTransitRouterEcrAttachmentAttribute API asynchronously
func (client *Client) UpdateTransitRouterEcrAttachmentAttributeWithCallback(request *UpdateTransitRouterEcrAttachmentAttributeRequest, callback func(response *UpdateTransitRouterEcrAttachmentAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTransitRouterEcrAttachmentAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateTransitRouterEcrAttachmentAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTransitRouterEcrAttachmentAttributeRequest is the request struct for api UpdateTransitRouterEcrAttachmentAttribute
type UpdateTransitRouterEcrAttachmentAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                    requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken                        string           `position:"Query" name:"ClientToken"`
	TransitRouterAttachmentName        string           `position:"Query" name:"TransitRouterAttachmentName"`
	DryRun                             requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount               string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                       string           `position:"Query" name:"OwnerAccount"`
	OwnerId                            requests.Integer `position:"Query" name:"OwnerId"`
	ResourceType                       string           `position:"Query" name:"ResourceType"`
	Version                            string           `position:"Query" name:"Version"`
	TransitRouterAttachmentId          string           `position:"Query" name:"TransitRouterAttachmentId"`
	TransitRouterAttachmentDescription string           `position:"Query" name:"TransitRouterAttachmentDescription"`
}

// UpdateTransitRouterEcrAttachmentAttributeResponse is the response struct for api UpdateTransitRouterEcrAttachmentAttribute
type UpdateTransitRouterEcrAttachmentAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateTransitRouterEcrAttachmentAttributeRequest creates a request to invoke UpdateTransitRouterEcrAttachmentAttribute API
func CreateUpdateTransitRouterEcrAttachmentAttributeRequest() (request *UpdateTransitRouterEcrAttachmentAttributeRequest) {
	request = &UpdateTransitRouterEcrAttachmentAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "UpdateTransitRouterEcrAttachmentAttribute", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateTransitRouterEcrAttachmentAttributeResponse creates a response to parse from UpdateTransitRouterEcrAttachmentAttribute response
func CreateUpdateTransitRouterEcrAttachmentAttributeResponse() (response *UpdateTransitRouterEcrAttachmentAttributeResponse) {
	response = &UpdateTransitRouterEcrAttachmentAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
