package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyTransitRouterMulticastDomain invokes the cbn.ModifyTransitRouterMulticastDomain API synchronously
func (client *Client) ModifyTransitRouterMulticastDomain(request *ModifyTransitRouterMulticastDomainRequest) (response *ModifyTransitRouterMulticastDomainResponse, err error) {
	response = CreateModifyTransitRouterMulticastDomainResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyTransitRouterMulticastDomainWithChan invokes the cbn.ModifyTransitRouterMulticastDomain API asynchronously
func (client *Client) ModifyTransitRouterMulticastDomainWithChan(request *ModifyTransitRouterMulticastDomainRequest) (<-chan *ModifyTransitRouterMulticastDomainResponse, <-chan error) {
	responseChan := make(chan *ModifyTransitRouterMulticastDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyTransitRouterMulticastDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyTransitRouterMulticastDomainWithCallback invokes the cbn.ModifyTransitRouterMulticastDomain API asynchronously
func (client *Client) ModifyTransitRouterMulticastDomainWithCallback(request *ModifyTransitRouterMulticastDomainRequest, callback func(response *ModifyTransitRouterMulticastDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyTransitRouterMulticastDomainResponse
		var err error
		defer close(result)
		response, err = client.ModifyTransitRouterMulticastDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyTransitRouterMulticastDomainRequest is the request struct for api ModifyTransitRouterMulticastDomain
type ModifyTransitRouterMulticastDomainRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                         requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken                             string           `position:"Query" name:"ClientToken"`
	TransitRouterMulticastDomainId          string           `position:"Query" name:"TransitRouterMulticastDomainId"`
	TransitRouterMulticastDomainDescription string           `position:"Query" name:"TransitRouterMulticastDomainDescription"`
	TransitRouterMulticastDomainName        string           `position:"Query" name:"TransitRouterMulticastDomainName"`
	DryRun                                  requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount                    string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                            string           `position:"Query" name:"OwnerAccount"`
	OwnerId                                 requests.Integer `position:"Query" name:"OwnerId"`
	Version                                 string           `position:"Query" name:"Version"`
}

// ModifyTransitRouterMulticastDomainResponse is the response struct for api ModifyTransitRouterMulticastDomain
type ModifyTransitRouterMulticastDomainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyTransitRouterMulticastDomainRequest creates a request to invoke ModifyTransitRouterMulticastDomain API
func CreateModifyTransitRouterMulticastDomainRequest() (request *ModifyTransitRouterMulticastDomainRequest) {
	request = &ModifyTransitRouterMulticastDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "ModifyTransitRouterMulticastDomain", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyTransitRouterMulticastDomainResponse creates a response to parse from ModifyTransitRouterMulticastDomain response
func CreateModifyTransitRouterMulticastDomainResponse() (response *ModifyTransitRouterMulticastDomainResponse) {
	response = &ModifyTransitRouterMulticastDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
