package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyTransitRouterCidr invokes the cbn.ModifyTransitRouterCidr API synchronously
func (client *Client) ModifyTransitRouterCidr(request *ModifyTransitRouterCidrRequest) (response *ModifyTransitRouterCidrResponse, err error) {
	response = CreateModifyTransitRouterCidrResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyTransitRouterCidrWithChan invokes the cbn.ModifyTransitRouterCidr API asynchronously
func (client *Client) ModifyTransitRouterCidrWithChan(request *ModifyTransitRouterCidrRequest) (<-chan *ModifyTransitRouterCidrResponse, <-chan error) {
	responseChan := make(chan *ModifyTransitRouterCidrResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyTransitRouterCidr(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyTransitRouterCidrWithCallback invokes the cbn.ModifyTransitRouterCidr API asynchronously
func (client *Client) ModifyTransitRouterCidrWithCallback(request *ModifyTransitRouterCidrRequest, callback func(response *ModifyTransitRouterCidrResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyTransitRouterCidrResponse
		var err error
		defer close(result)
		response, err = client.ModifyTransitRouterCidr(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyTransitRouterCidrRequest is the request struct for api ModifyTransitRouterCidr
type ModifyTransitRouterCidrRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	Description          string           `position:"Query" name:"Description"`
	TransitRouterCidrId  string           `position:"Query" name:"TransitRouterCidrId"`
	Cidr                 string           `position:"Query" name:"Cidr"`
	PublishCidrRoute     requests.Boolean `position:"Query" name:"PublishCidrRoute"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TransitRouterId      string           `position:"Query" name:"TransitRouterId"`
	Version              string           `position:"Query" name:"Version"`
	Name                 string           `position:"Query" name:"Name"`
}

// ModifyTransitRouterCidrResponse is the response struct for api ModifyTransitRouterCidr
type ModifyTransitRouterCidrResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyTransitRouterCidrRequest creates a request to invoke ModifyTransitRouterCidr API
func CreateModifyTransitRouterCidrRequest() (request *ModifyTransitRouterCidrRequest) {
	request = &ModifyTransitRouterCidrRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "ModifyTransitRouterCidr", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyTransitRouterCidrResponse creates a response to parse from ModifyTransitRouterCidr response
func CreateModifyTransitRouterCidrResponse() (response *ModifyTransitRouterCidrResponse) {
	response = &ModifyTransitRouterCidrResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
