package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelOrderRequest invokes the cas.CancelOrderRequest API synchronously
func (client *Client) CancelOrderRequest(request *CancelOrderRequestRequest) (response *CancelOrderRequestResponse, err error) {
	response = CreateCancelOrderRequestResponse()
	err = client.DoAction(request, response)
	return
}

// CancelOrderRequestWithChan invokes the cas.CancelOrderRequest API asynchronously
func (client *Client) CancelOrderRequestWithChan(request *CancelOrderRequestRequest) (<-chan *CancelOrderRequestResponse, <-chan error) {
	responseChan := make(chan *CancelOrderRequestResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelOrderRequest(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelOrderRequestWithCallback invokes the cas.CancelOrderRequest API asynchronously
func (client *Client) CancelOrderRequestWithCallback(request *CancelOrderRequestRequest, callback func(response *CancelOrderRequestResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelOrderRequestResponse
		var err error
		defer close(result)
		response, err = client.CancelOrderRequest(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelOrderRequestRequest is the request struct for api CancelOrderRequest
type CancelOrderRequestRequest struct {
	*requests.RpcRequest
	OrderId  requests.Integer `position:"Query" name:"OrderId"`
	SourceIp string           `position:"Query" name:"SourceIp"`
}

// CancelOrderRequestResponse is the response struct for api CancelOrderRequest
type CancelOrderRequestResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCancelOrderRequestRequest creates a request to invoke CancelOrderRequest API
func CreateCancelOrderRequestRequest() (request *CancelOrderRequestRequest) {
	request = &CancelOrderRequestRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2020-04-07", "CancelOrderRequest", "cas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCancelOrderRequestResponse creates a response to parse from CancelOrderRequest response
func CreateCancelOrderRequestResponse() (response *CancelOrderRequestResponse) {
	response = &CancelOrderRequestResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
