package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySkuPriceList invokes the bssopenapi.QuerySkuPriceList API synchronously
func (client *Client) QuerySkuPriceList(request *QuerySkuPriceListRequest) (response *QuerySkuPriceListResponse, err error) {
	response = CreateQuerySkuPriceListResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySkuPriceListWithChan invokes the bssopenapi.QuerySkuPriceList API asynchronously
func (client *Client) QuerySkuPriceListWithChan(request *QuerySkuPriceListRequest) (<-chan *QuerySkuPriceListResponse, <-chan error) {
	responseChan := make(chan *QuerySkuPriceListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySkuPriceList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySkuPriceListWithCallback invokes the bssopenapi.QuerySkuPriceList API asynchronously
func (client *Client) QuerySkuPriceListWithCallback(request *QuerySkuPriceListRequest, callback func(response *QuerySkuPriceListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySkuPriceListResponse
		var err error
		defer close(result)
		response, err = client.QuerySkuPriceList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySkuPriceListRequest is the request struct for api QuerySkuPriceList
type QuerySkuPriceListRequest struct {
	*requests.RpcRequest
	NextPageToken           string               `position:"Query" name:"NextPageToken"`
	CommodityCode           string               `position:"Query" name:"CommodityCode"`
	PriceFactorConditionMap map[string]*[]string `position:"Query" name:"PriceFactorConditionMap"  type:"Map"`
	PriceEntityCode         string               `position:"Query" name:"PriceEntityCode"`
	PageSize                requests.Integer     `position:"Query" name:"PageSize"`
}

// QuerySkuPriceListResponse is the response struct for api QuerySkuPriceList
type QuerySkuPriceListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQuerySkuPriceListRequest creates a request to invoke QuerySkuPriceList API
func CreateQuerySkuPriceListRequest() (request *QuerySkuPriceListRequest) {
	request = &QuerySkuPriceListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "QuerySkuPriceList", "bssopenapi", "openAPI")
	request.Method = requests.GET
	return
}

// CreateQuerySkuPriceListResponse creates a response to parse from QuerySkuPriceList response
func CreateQuerySkuPriceListResponse() (response *QuerySkuPriceListResponse) {
	response = &QuerySkuPriceListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
