package bpstudio

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetExecuteOperationResult invokes the bpstudio.GetExecuteOperationResult API synchronously
func (client *Client) GetExecuteOperationResult(request *GetExecuteOperationResultRequest) (response *GetExecuteOperationResultResponse, err error) {
	response = CreateGetExecuteOperationResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetExecuteOperationResultWithChan invokes the bpstudio.GetExecuteOperationResult API asynchronously
func (client *Client) GetExecuteOperationResultWithChan(request *GetExecuteOperationResultRequest) (<-chan *GetExecuteOperationResultResponse, <-chan error) {
	responseChan := make(chan *GetExecuteOperationResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetExecuteOperationResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetExecuteOperationResultWithCallback invokes the bpstudio.GetExecuteOperationResult API asynchronously
func (client *Client) GetExecuteOperationResultWithCallback(request *GetExecuteOperationResultRequest, callback func(response *GetExecuteOperationResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetExecuteOperationResultResponse
		var err error
		defer close(result)
		response, err = client.GetExecuteOperationResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetExecuteOperationResultRequest is the request struct for api GetExecuteOperationResult
type GetExecuteOperationResultRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Body" name:"ResourceGroupId"`
	OperationId     string `position:"Body" name:"OperationId"`
}

// GetExecuteOperationResultResponse is the response struct for api GetExecuteOperationResult
type GetExecuteOperationResultResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetExecuteOperationResultRequest creates a request to invoke GetExecuteOperationResult API
func CreateGetExecuteOperationResultRequest() (request *GetExecuteOperationResultRequest) {
	request = &GetExecuteOperationResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BPStudio", "2021-09-31", "GetExecuteOperationResult", "bpstudio", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetExecuteOperationResultResponse creates a response to parse from GetExecuteOperationResult response
func CreateGetExecuteOperationResultResponse() (response *GetExecuteOperationResultResponse) {
	response = &GetExecuteOperationResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
