package biz_ipdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MapIpSegment invokes the biz_ipdb.MapIpSegment API synchronously
func (client *Client) MapIpSegment(request *MapIpSegmentRequest) (response *MapIpSegmentResponse, err error) {
	response = CreateMapIpSegmentResponse()
	err = client.DoAction(request, response)
	return
}

// MapIpSegmentWithChan invokes the biz_ipdb.MapIpSegment API asynchronously
func (client *Client) MapIpSegmentWithChan(request *MapIpSegmentRequest) (<-chan *MapIpSegmentResponse, <-chan error) {
	responseChan := make(chan *MapIpSegmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MapIpSegment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MapIpSegmentWithCallback invokes the biz_ipdb.MapIpSegment API asynchronously
func (client *Client) MapIpSegmentWithCallback(request *MapIpSegmentRequest, callback func(response *MapIpSegmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MapIpSegmentResponse
		var err error
		defer close(result)
		response, err = client.MapIpSegment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MapIpSegmentRequest is the request struct for api MapIpSegment
type MapIpSegmentRequest struct {
	*requests.RpcRequest
	Cluster    string `position:"Query" name:"Cluster"`
	LocationId string `position:"Query" name:"LocationId"`
	IpType     string `position:"Query" name:"IpType"`
	Value      string `position:"Query" name:"Value"`
	BizLine    string `position:"Query" name:"BizLine"`
}

// MapIpSegmentResponse is the response struct for api MapIpSegment
type MapIpSegmentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateMapIpSegmentRequest creates a request to invoke MapIpSegment API
func CreateMapIpSegmentRequest() (request *MapIpSegmentRequest) {
	request = &MapIpSegmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Biz-ipdb", "2016-08-08", "MapIpSegment", "", "")
	request.Method = requests.POST
	return
}

// CreateMapIpSegmentResponse creates a response to parse from MapIpSegment response
func CreateMapIpSegmentResponse() (response *MapIpSegmentResponse) {
	response = &MapIpSegmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
