package beian

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitAccessorFullDomainsOssList invokes the beian.SubmitAccessorFullDomainsOssList API synchronously
func (client *Client) SubmitAccessorFullDomainsOssList(request *SubmitAccessorFullDomainsOssListRequest) (response *SubmitAccessorFullDomainsOssListResponse, err error) {
	response = CreateSubmitAccessorFullDomainsOssListResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitAccessorFullDomainsOssListWithChan invokes the beian.SubmitAccessorFullDomainsOssList API asynchronously
func (client *Client) SubmitAccessorFullDomainsOssListWithChan(request *SubmitAccessorFullDomainsOssListRequest) (<-chan *SubmitAccessorFullDomainsOssListResponse, <-chan error) {
	responseChan := make(chan *SubmitAccessorFullDomainsOssListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitAccessorFullDomainsOssList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitAccessorFullDomainsOssListWithCallback invokes the beian.SubmitAccessorFullDomainsOssList API asynchronously
func (client *Client) SubmitAccessorFullDomainsOssListWithCallback(request *SubmitAccessorFullDomainsOssListRequest, callback func(response *SubmitAccessorFullDomainsOssListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitAccessorFullDomainsOssListResponse
		var err error
		defer close(result)
		response, err = client.SubmitAccessorFullDomainsOssList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitAccessorFullDomainsOssListRequest is the request struct for api SubmitAccessorFullDomainsOssList
type SubmitAccessorFullDomainsOssListRequest struct {
	*requests.RpcRequest
	Caller  string    `position:"Query" name:"Caller"`
	OssList *[]string `position:"Query" name:"OssList"  type:"Repeated"`
}

// SubmitAccessorFullDomainsOssListResponse is the response struct for api SubmitAccessorFullDomainsOssList
type SubmitAccessorFullDomainsOssListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateSubmitAccessorFullDomainsOssListRequest creates a request to invoke SubmitAccessorFullDomainsOssList API
func CreateSubmitAccessorFullDomainsOssListRequest() (request *SubmitAccessorFullDomainsOssListRequest) {
	request = &SubmitAccessorFullDomainsOssListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Beian", "2016-08-10", "SubmitAccessorFullDomainsOssList", "", "")
	request.Method = requests.POST
	return
}

// CreateSubmitAccessorFullDomainsOssListResponse creates a response to parse from SubmitAccessorFullDomainsOssList response
func CreateSubmitAccessorFullDomainsOssListResponse() (response *SubmitAccessorFullDomainsOssListResponse) {
	response = &SubmitAccessorFullDomainsOssListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
