package beian

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ManageAccessorIp invokes the beian.ManageAccessorIp API synchronously
func (client *Client) ManageAccessorIp(request *ManageAccessorIpRequest) (response *ManageAccessorIpResponse, err error) {
	response = CreateManageAccessorIpResponse()
	err = client.DoAction(request, response)
	return
}

// ManageAccessorIpWithChan invokes the beian.ManageAccessorIp API asynchronously
func (client *Client) ManageAccessorIpWithChan(request *ManageAccessorIpRequest) (<-chan *ManageAccessorIpResponse, <-chan error) {
	responseChan := make(chan *ManageAccessorIpResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ManageAccessorIp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ManageAccessorIpWithCallback invokes the beian.ManageAccessorIp API asynchronously
func (client *Client) ManageAccessorIpWithCallback(request *ManageAccessorIpRequest, callback func(response *ManageAccessorIpResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ManageAccessorIpResponse
		var err error
		defer close(result)
		response, err = client.ManageAccessorIp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ManageAccessorIpRequest is the request struct for api ManageAccessorIp
type ManageAccessorIpRequest struct {
	*requests.RpcRequest
	Ip        string           `position:"Query" name:"Ip"`
	Remark    string           `position:"Query" name:"Remark"`
	Caller    string           `position:"Query" name:"Caller"`
	IpVersion requests.Integer `position:"Query" name:"IpVersion"`
	Operation string           `position:"Query" name:"Operation"`
}

// ManageAccessorIpResponse is the response struct for api ManageAccessorIp
type ManageAccessorIpResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateManageAccessorIpRequest creates a request to invoke ManageAccessorIp API
func CreateManageAccessorIpRequest() (request *ManageAccessorIpRequest) {
	request = &ManageAccessorIpRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Beian", "2016-08-10", "ManageAccessorIp", "", "")
	request.Method = requests.POST
	return
}

// CreateManageAccessorIpResponse creates a response to parse from ManageAccessorIp response
func CreateManageAccessorIpResponse() (response *ManageAccessorIpResponse) {
	response = &ManageAccessorIpResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
