package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InstantiateFabricChaincode invokes the baas.InstantiateFabricChaincode API synchronously
// api document: https://help.aliyun.com/api/baas/instantiatefabricchaincode.html
func (client *Client) InstantiateFabricChaincode(request *InstantiateFabricChaincodeRequest) (response *InstantiateFabricChaincodeResponse, err error) {
	response = CreateInstantiateFabricChaincodeResponse()
	err = client.DoAction(request, response)
	return
}

// InstantiateFabricChaincodeWithChan invokes the baas.InstantiateFabricChaincode API asynchronously
// api document: https://help.aliyun.com/api/baas/instantiatefabricchaincode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InstantiateFabricChaincodeWithChan(request *InstantiateFabricChaincodeRequest) (<-chan *InstantiateFabricChaincodeResponse, <-chan error) {
	responseChan := make(chan *InstantiateFabricChaincodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InstantiateFabricChaincode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InstantiateFabricChaincodeWithCallback invokes the baas.InstantiateFabricChaincode API asynchronously
// api document: https://help.aliyun.com/api/baas/instantiatefabricchaincode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InstantiateFabricChaincodeWithCallback(request *InstantiateFabricChaincodeRequest, callback func(response *InstantiateFabricChaincodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InstantiateFabricChaincodeResponse
		var err error
		defer close(result)
		response, err = client.InstantiateFabricChaincode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InstantiateFabricChaincodeRequest is the request struct for api InstantiateFabricChaincode
type InstantiateFabricChaincodeRequest struct {
	*requests.RpcRequest
	EndorsePolicy    string `position:"Body" name:"EndorsePolicy"`
	OrganizationId   string `position:"Body" name:"OrganizationId"`
	ChaincodeId      string `position:"Body" name:"ChaincodeId"`
	CollectionConfig string `position:"Body" name:"CollectionConfig"`
	Location         string `position:"Body" name:"Location"`
}

// InstantiateFabricChaincodeResponse is the response struct for api InstantiateFabricChaincode
type InstantiateFabricChaincodeResponse struct {
	*responses.BaseResponse
	RequestId string                             `json:"RequestId" xml:"RequestId"`
	Success   bool                               `json:"Success" xml:"Success"`
	ErrorCode int                                `json:"ErrorCode" xml:"ErrorCode"`
	Result    ResultInInstantiateFabricChaincode `json:"Result" xml:"Result"`
}

// CreateInstantiateFabricChaincodeRequest creates a request to invoke InstantiateFabricChaincode API
func CreateInstantiateFabricChaincodeRequest() (request *InstantiateFabricChaincodeRequest) {
	request = &InstantiateFabricChaincodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "InstantiateFabricChaincode", "baas", "openAPI")
	return
}

// CreateInstantiateFabricChaincodeResponse creates a response to parse from InstantiateFabricChaincode response
func CreateInstantiateFabricChaincodeResponse() (response *InstantiateFabricChaincodeResponse) {
	response = &InstantiateFabricChaincodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
