package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InstallCmsExporter invokes the arms.InstallCmsExporter API synchronously
func (client *Client) InstallCmsExporter(request *InstallCmsExporterRequest) (response *InstallCmsExporterResponse, err error) {
	response = CreateInstallCmsExporterResponse()
	err = client.DoAction(request, response)
	return
}

// InstallCmsExporterWithChan invokes the arms.InstallCmsExporter API asynchronously
func (client *Client) InstallCmsExporterWithChan(request *InstallCmsExporterRequest) (<-chan *InstallCmsExporterResponse, <-chan error) {
	responseChan := make(chan *InstallCmsExporterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InstallCmsExporter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InstallCmsExporterWithCallback invokes the arms.InstallCmsExporter API asynchronously
func (client *Client) InstallCmsExporterWithCallback(request *InstallCmsExporterRequest, callback func(response *InstallCmsExporterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InstallCmsExporterResponse
		var err error
		defer close(result)
		response, err = client.InstallCmsExporter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InstallCmsExporterRequest is the request struct for api InstallCmsExporter
type InstallCmsExporterRequest struct {
	*requests.RpcRequest
	ClusterId  string           `position:"Query" name:"ClusterId"`
	DirectArgs string           `position:"Query" name:"DirectArgs"`
	CmsArgs    string           `position:"Query" name:"CmsArgs"`
	EnableTag  requests.Boolean `position:"Query" name:"EnableTag"`
}

// InstallCmsExporterResponse is the response struct for api InstallCmsExporter
type InstallCmsExporterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateInstallCmsExporterRequest creates a request to invoke InstallCmsExporter API
func CreateInstallCmsExporterRequest() (request *InstallCmsExporterRequest) {
	request = &InstallCmsExporterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "InstallCmsExporter", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateInstallCmsExporterResponse creates a response to parse from InstallCmsExporter response
func CreateInstallCmsExporterResponse() (response *InstallCmsExporterResponse) {
	response = &InstallCmsExporterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
