package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRetcodeLogstore invokes the arms.GetRetcodeLogstore API synchronously
func (client *Client) GetRetcodeLogstore(request *GetRetcodeLogstoreRequest) (response *GetRetcodeLogstoreResponse, err error) {
	response = CreateGetRetcodeLogstoreResponse()
	err = client.DoAction(request, response)
	return
}

// GetRetcodeLogstoreWithChan invokes the arms.GetRetcodeLogstore API asynchronously
func (client *Client) GetRetcodeLogstoreWithChan(request *GetRetcodeLogstoreRequest) (<-chan *GetRetcodeLogstoreResponse, <-chan error) {
	responseChan := make(chan *GetRetcodeLogstoreResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRetcodeLogstore(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRetcodeLogstoreWithCallback invokes the arms.GetRetcodeLogstore API asynchronously
func (client *Client) GetRetcodeLogstoreWithCallback(request *GetRetcodeLogstoreRequest, callback func(response *GetRetcodeLogstoreResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRetcodeLogstoreResponse
		var err error
		defer close(result)
		response, err = client.GetRetcodeLogstore(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRetcodeLogstoreRequest is the request struct for api GetRetcodeLogstore
type GetRetcodeLogstoreRequest struct {
	*requests.RpcRequest
	Pid string `position:"Query" name:"Pid"`
}

// GetRetcodeLogstoreResponse is the response struct for api GetRetcodeLogstore
type GetRetcodeLogstoreResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetRetcodeLogstoreRequest creates a request to invoke GetRetcodeLogstore API
func CreateGetRetcodeLogstoreRequest() (request *GetRetcodeLogstoreRequest) {
	request = &GetRetcodeLogstoreRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "GetRetcodeLogstore", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetRetcodeLogstoreResponse creates a response to parse from GetRetcodeLogstore response
func CreateGetRetcodeLogstoreResponse() (response *GetRetcodeLogstoreResponse) {
	response = &GetRetcodeLogstoreResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
