package appstream_center

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyAppInstanceGroupAttribute invokes the appstream_center.ModifyAppInstanceGroupAttribute API synchronously
func (client *Client) ModifyAppInstanceGroupAttribute(request *ModifyAppInstanceGroupAttributeRequest) (response *ModifyAppInstanceGroupAttributeResponse, err error) {
	response = CreateModifyAppInstanceGroupAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyAppInstanceGroupAttributeWithChan invokes the appstream_center.ModifyAppInstanceGroupAttribute API asynchronously
func (client *Client) ModifyAppInstanceGroupAttributeWithChan(request *ModifyAppInstanceGroupAttributeRequest) (<-chan *ModifyAppInstanceGroupAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyAppInstanceGroupAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyAppInstanceGroupAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyAppInstanceGroupAttributeWithCallback invokes the appstream_center.ModifyAppInstanceGroupAttribute API asynchronously
func (client *Client) ModifyAppInstanceGroupAttributeWithCallback(request *ModifyAppInstanceGroupAttributeRequest, callback func(response *ModifyAppInstanceGroupAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyAppInstanceGroupAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyAppInstanceGroupAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyAppInstanceGroupAttributeRequest is the request struct for api ModifyAppInstanceGroupAttribute
type ModifyAppInstanceGroupAttributeRequest struct {
	*requests.RpcRequest
	NodePool             ModifyAppInstanceGroupAttributeNodePool `position:"Query" name:"NodePool"  type:"Struct"`
	ProductType          string                                  `position:"Query" name:"ProductType"`
	AppInstanceGroupName string                                  `position:"Query" name:"AppInstanceGroupName"`
	SessionTimeout       requests.Integer                        `position:"Query" name:"SessionTimeout"`
	AppInstanceGroupId   string                                  `position:"Query" name:"AppInstanceGroupId"`
}

// ModifyAppInstanceGroupAttributeNodePool is a repeated param struct in ModifyAppInstanceGroupAttributeRequest
type ModifyAppInstanceGroupAttributeNodePool struct {
	NodePoolId   string `name:"NodePoolId"`
	NodeCapacity string `name:"NodeCapacity"`
}

// ModifyAppInstanceGroupAttributeResponse is the response struct for api ModifyAppInstanceGroupAttribute
type ModifyAppInstanceGroupAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateModifyAppInstanceGroupAttributeRequest creates a request to invoke ModifyAppInstanceGroupAttribute API
func CreateModifyAppInstanceGroupAttributeRequest() (request *ModifyAppInstanceGroupAttributeRequest) {
	request = &ModifyAppInstanceGroupAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("appstream-center", "2021-09-01", "ModifyAppInstanceGroupAttribute", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyAppInstanceGroupAttributeResponse creates a response to parse from ModifyAppInstanceGroupAttribute response
func CreateModifyAppInstanceGroupAttributeResponse() (response *ModifyAppInstanceGroupAttributeResponse) {
	response = &ModifyAppInstanceGroupAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
