package amqp_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteVirtualHost invokes the amqp_open.DeleteVirtualHost API synchronously
func (client *Client) DeleteVirtualHost(request *DeleteVirtualHostRequest) (response *DeleteVirtualHostResponse, err error) {
	response = CreateDeleteVirtualHostResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteVirtualHostWithChan invokes the amqp_open.DeleteVirtualHost API asynchronously
func (client *Client) DeleteVirtualHostWithChan(request *DeleteVirtualHostRequest) (<-chan *DeleteVirtualHostResponse, <-chan error) {
	responseChan := make(chan *DeleteVirtualHostResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteVirtualHost(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteVirtualHostWithCallback invokes the amqp_open.DeleteVirtualHost API asynchronously
func (client *Client) DeleteVirtualHostWithCallback(request *DeleteVirtualHostRequest, callback func(response *DeleteVirtualHostResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteVirtualHostResponse
		var err error
		defer close(result)
		response, err = client.DeleteVirtualHost(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteVirtualHostRequest is the request struct for api DeleteVirtualHost
type DeleteVirtualHostRequest struct {
	*requests.RpcRequest
	InstanceId  string `position:"Body" name:"InstanceId"`
	VirtualHost string `position:"Body" name:"VirtualHost"`
}

// DeleteVirtualHostResponse is the response struct for api DeleteVirtualHost
type DeleteVirtualHostResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteVirtualHostRequest creates a request to invoke DeleteVirtualHost API
func CreateDeleteVirtualHostRequest() (request *DeleteVirtualHostRequest) {
	request = &DeleteVirtualHostRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("amqp-open", "2019-12-12", "DeleteVirtualHost", "onsproxy", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteVirtualHostResponse creates a response to parse from DeleteVirtualHost response
func CreateDeleteVirtualHostResponse() (response *DeleteVirtualHostResponse) {
	response = &DeleteVirtualHostResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
