package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCateChEcom invokes the alinlp.GetCateChEcom API synchronously
func (client *Client) GetCateChEcom(request *GetCateChEcomRequest) (response *GetCateChEcomResponse, err error) {
	response = CreateGetCateChEcomResponse()
	err = client.DoAction(request, response)
	return
}

// GetCateChEcomWithChan invokes the alinlp.GetCateChEcom API asynchronously
func (client *Client) GetCateChEcomWithChan(request *GetCateChEcomRequest) (<-chan *GetCateChEcomResponse, <-chan error) {
	responseChan := make(chan *GetCateChEcomResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCateChEcom(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCateChEcomWithCallback invokes the alinlp.GetCateChEcom API asynchronously
func (client *Client) GetCateChEcomWithCallback(request *GetCateChEcomRequest, callback func(response *GetCateChEcomResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCateChEcomResponse
		var err error
		defer close(result)
		response, err = client.GetCateChEcom(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCateChEcomRequest is the request struct for api GetCateChEcom
type GetCateChEcomRequest struct {
	*requests.RpcRequest
	Business    string `position:"Query" name:"Business"`
	ServiceCode string `position:"Body" name:"ServiceCode"`
	ImageUrl    string `position:"Body" name:"ImageUrl"`
	Text        string `position:"Body" name:"Text"`
}

// GetCateChEcomResponse is the response struct for api GetCateChEcom
type GetCateChEcomResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetCateChEcomRequest creates a request to invoke GetCateChEcom API
func CreateGetCateChEcomRequest() (request *GetCateChEcomRequest) {
	request = &GetCateChEcomRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetCateChEcom", "alinlp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetCateChEcomResponse creates a response to parse from GetCateChEcom response
func CreateGetCateChEcomResponse() (response *GetCateChEcomResponse) {
	response = &GetCateChEcomResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
