package alikafka

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateConsumerOffset invokes the alikafka.UpdateConsumerOffset API synchronously
func (client *Client) UpdateConsumerOffset(request *UpdateConsumerOffsetRequest) (response *UpdateConsumerOffsetResponse, err error) {
	response = CreateUpdateConsumerOffsetResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateConsumerOffsetWithChan invokes the alikafka.UpdateConsumerOffset API asynchronously
func (client *Client) UpdateConsumerOffsetWithChan(request *UpdateConsumerOffsetRequest) (<-chan *UpdateConsumerOffsetResponse, <-chan error) {
	responseChan := make(chan *UpdateConsumerOffsetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateConsumerOffset(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateConsumerOffsetWithCallback invokes the alikafka.UpdateConsumerOffset API asynchronously
func (client *Client) UpdateConsumerOffsetWithCallback(request *UpdateConsumerOffsetRequest, callback func(response *UpdateConsumerOffsetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateConsumerOffsetResponse
		var err error
		defer close(result)
		response, err = client.UpdateConsumerOffset(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateConsumerOffsetRequest is the request struct for api UpdateConsumerOffset
type UpdateConsumerOffsetRequest struct {
	*requests.RpcRequest
	ConsumerId string                         `position:"Query" name:"ConsumerId"`
	ResetType  string                         `position:"Query" name:"ResetType"`
	InstanceId string                         `position:"Query" name:"InstanceId"`
	Offsets    *[]UpdateConsumerOffsetOffsets `position:"Query" name:"Offsets"  type:"Json"`
	Topic      string                         `position:"Query" name:"Topic"`
	Time       string                         `position:"Query" name:"Time"`
}

// UpdateConsumerOffsetOffsets is a repeated param struct in UpdateConsumerOffsetRequest
type UpdateConsumerOffsetOffsets struct {
	Partition string `name:"Partition"`
	Offset    string `name:"Offset"`
}

// UpdateConsumerOffsetResponse is the response struct for api UpdateConsumerOffset
type UpdateConsumerOffsetResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateUpdateConsumerOffsetRequest creates a request to invoke UpdateConsumerOffset API
func CreateUpdateConsumerOffsetRequest() (request *UpdateConsumerOffsetRequest) {
	request = &UpdateConsumerOffsetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alikafka", "2019-09-16", "UpdateConsumerOffset", "alikafka", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateConsumerOffsetResponse creates a response to parse from UpdateConsumerOffset response
func CreateUpdateConsumerOffsetResponse() (response *UpdateConsumerOffsetResponse) {
	response = &UpdateConsumerOffsetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
