package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// LoadBalancerLeaveSecurityGroup invokes the alb.LoadBalancerLeaveSecurityGroup API synchronously
func (client *Client) LoadBalancerLeaveSecurityGroup(request *LoadBalancerLeaveSecurityGroupRequest) (response *LoadBalancerLeaveSecurityGroupResponse, err error) {
	response = CreateLoadBalancerLeaveSecurityGroupResponse()
	err = client.DoAction(request, response)
	return
}

// LoadBalancerLeaveSecurityGroupWithChan invokes the alb.LoadBalancerLeaveSecurityGroup API asynchronously
func (client *Client) LoadBalancerLeaveSecurityGroupWithChan(request *LoadBalancerLeaveSecurityGroupRequest) (<-chan *LoadBalancerLeaveSecurityGroupResponse, <-chan error) {
	responseChan := make(chan *LoadBalancerLeaveSecurityGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.LoadBalancerLeaveSecurityGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// LoadBalancerLeaveSecurityGroupWithCallback invokes the alb.LoadBalancerLeaveSecurityGroup API asynchronously
func (client *Client) LoadBalancerLeaveSecurityGroupWithCallback(request *LoadBalancerLeaveSecurityGroupRequest, callback func(response *LoadBalancerLeaveSecurityGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *LoadBalancerLeaveSecurityGroupResponse
		var err error
		defer close(result)
		response, err = client.LoadBalancerLeaveSecurityGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// LoadBalancerLeaveSecurityGroupRequest is the request struct for api LoadBalancerLeaveSecurityGroup
type LoadBalancerLeaveSecurityGroupRequest struct {
	*requests.RpcRequest
	ClientToken      string           `position:"Query" name:"ClientToken"`
	DryRun           requests.Boolean `position:"Query" name:"DryRun"`
	SecurityGroupIds *[]string        `position:"Query" name:"SecurityGroupIds"  type:"Repeated"`
	LoadBalancerId   string           `position:"Query" name:"LoadBalancerId"`
}

// LoadBalancerLeaveSecurityGroupResponse is the response struct for api LoadBalancerLeaveSecurityGroup
type LoadBalancerLeaveSecurityGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	JobId     string `json:"JobId" xml:"JobId"`
}

// CreateLoadBalancerLeaveSecurityGroupRequest creates a request to invoke LoadBalancerLeaveSecurityGroup API
func CreateLoadBalancerLeaveSecurityGroupRequest() (request *LoadBalancerLeaveSecurityGroupRequest) {
	request = &LoadBalancerLeaveSecurityGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "LoadBalancerLeaveSecurityGroup", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateLoadBalancerLeaveSecurityGroupResponse creates a response to parse from LoadBalancerLeaveSecurityGroup response
func CreateLoadBalancerLeaveSecurityGroupResponse() (response *LoadBalancerLeaveSecurityGroupResponse) {
	response = &LoadBalancerLeaveSecurityGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
