package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableAdviceService invokes the adb.EnableAdviceService API synchronously
func (client *Client) EnableAdviceService(request *EnableAdviceServiceRequest) (response *EnableAdviceServiceResponse, err error) {
	response = CreateEnableAdviceServiceResponse()
	err = client.DoAction(request, response)
	return
}

// EnableAdviceServiceWithChan invokes the adb.EnableAdviceService API asynchronously
func (client *Client) EnableAdviceServiceWithChan(request *EnableAdviceServiceRequest) (<-chan *EnableAdviceServiceResponse, <-chan error) {
	responseChan := make(chan *EnableAdviceServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableAdviceService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableAdviceServiceWithCallback invokes the adb.EnableAdviceService API asynchronously
func (client *Client) EnableAdviceServiceWithCallback(request *EnableAdviceServiceRequest, callback func(response *EnableAdviceServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableAdviceServiceResponse
		var err error
		defer close(result)
		response, err = client.EnableAdviceService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableAdviceServiceRequest is the request struct for api EnableAdviceService
type EnableAdviceServiceRequest struct {
	*requests.RpcRequest
	DBClusterId string `position:"Query" name:"DBClusterId"`
}

// EnableAdviceServiceResponse is the response struct for api EnableAdviceService
type EnableAdviceServiceResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableAdviceServiceRequest creates a request to invoke EnableAdviceService API
func CreateEnableAdviceServiceRequest() (request *EnableAdviceServiceRequest) {
	request = &EnableAdviceServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "EnableAdviceService", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableAdviceServiceResponse creates a response to parse from EnableAdviceService response
func CreateEnableAdviceServiceResponse() (response *EnableAdviceServiceResponse) {
	response = &EnableAdviceServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
