// Code Generated by gadget/xsdk, DO NOT EDIT

package gtm

import (
	"bytes"
	"context"
	"encoding/json"
	"net/http"
)

// Group: GTM
// GTM managerment

func (c *Client) CreateGTM(ctx context.Context, data *CreateGTMRequest) (*CreateGTMResponse, error) {
	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=CreateGTM", nil)
	if err != nil {
		return nil, err
	}

	q := req.URL.Query()
	if v := data.Owner; v != nil {
		q.Add("owner", *v)
	}
	if v := data.Domain; v != nil {
		q.Add("domain", *v)
	}
	if v := data.AccMode; v != nil {
		q.Add("acc_mode", *v)
	}
	if v := data.TTL; v != nil {
		q.Add("ttl", *v)
	}
	if v := data.SchedMode; v != nil {
		q.Add("sched_mode", *v)
	}
	if v := data.AddrType; v != nil {
		q.Add("addr_type", *v)
	}
	if v := data.Cname; v != nil {
		q.Add("cname", *v)
	}
	if v := data.PrivInfo; v != nil {
		q.Add("priv_info", *v)
	}
	if v := data.Platform; v != nil {
		q.Add("platform", *v)
	}
	if v := data.Version; v != nil {
		q.Add("Version", *v)
	}
	if v := data.MaxServer; v != nil {
		q.Add("max_server", *v)
	}
	if v := data.LbMode; v != nil {
		q.Add("lb_mode", *v)
	}
	if v := data.LastOperator; v != nil {
		q.Add("last_operator", *v)
	}
	if v := data.AlarmOnly; v != nil {
		q.Add("alarm_only", *v)
	}
	if v := data.FoMode; v != nil {
		q.Add("fo_mode", *v)
	}
	req.URL.RawQuery = q.Encode()

	if v := data.XTopAccountId; v != nil {
		req.Header.Set("X-Top-Account-Id", *v)
	}
	if v := data.XTopUserId; v != nil {
		req.Header.Set("X-Top-User-Id", *v)
	}
	if v := data.XTopRequestId; v != nil {
		req.Header.Set("X-Top-Request-Id", *v)
	}
	if v := data.XTopService; v != nil {
		req.Header.Set("X-Top-Service", *v)
	}
	if v := data.XTopRegion; v != nil {
		req.Header.Set("X-Top-Region", *v)
	}

	if v, ok := ctx.Value("K_LOGID").(string); ok {
		req.Header.Set("X-TT-LOGID", v)
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload CreateGTMResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) DeleteGTM(ctx context.Context, data *DeleteGTMRequest) error {
	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=DeleteGTM", nil)
	if err != nil {
		return err
	}

	q := req.URL.Query()
	if v := data.Version; v != nil {
		q.Add("Version", *v)
	}
	if v := data.ID; v != nil {
		q.Add("id", *v)
	}
	req.URL.RawQuery = q.Encode()

	if v := data.XTopRegion; v != nil {
		req.Header.Set("X-Top-Region", *v)
	}
	if v := data.XTopAccountId; v != nil {
		req.Header.Set("X-Top-Account-Id", *v)
	}
	if v := data.XTopUserId; v != nil {
		req.Header.Set("X-Top-User-Id", *v)
	}
	if v := data.XTopRequestId; v != nil {
		req.Header.Set("X-Top-Request-Id", *v)
	}
	if v := data.XTopService; v != nil {
		req.Header.Set("X-Top-Service", *v)
	}

	if v, ok := ctx.Value("K_LOGID").(string); ok {
		req.Header.Set("X-TT-LOGID", v)
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return err
	}
	defer resp.Body.Close()

	return nil
}

func (c *Client) FindGTMs(ctx context.Context, data *FindGTMsRequest) (*FindGTMsResponse, error) {
	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=FindGTMs", nil)
	if err != nil {
		return nil, err
	}

	q := req.URL.Query()
	if v := data.PrivInfo; v != nil {
		q.Add("priv_info", *v)
	}
	if v := data.Domain; v != nil {
		q.Add("domain", *v)
	}
	if v := data.Cname; v != nil {
		q.Add("cname", *v)
	}
	if v := data.DnsProv; v != nil {
		q.Add("dns_prov", *v)
	}
	if v := data.State; v != nil {
		q.Add("state", *v)
	}
	if v := data.PageNumber; v != nil {
		q.Add("page_number", *v)
	}
	if v := data.Version; v != nil {
		q.Add("Version", *v)
	}
	if v := data.PageSize; v != nil {
		q.Add("page_size", *v)
	}
	req.URL.RawQuery = q.Encode()

	if v := data.XTopAccountId; v != nil {
		req.Header.Set("X-Top-Account-Id", *v)
	}
	if v := data.XTopUserId; v != nil {
		req.Header.Set("X-Top-User-Id", *v)
	}
	if v := data.XTopRequestId; v != nil {
		req.Header.Set("X-Top-Request-Id", *v)
	}
	if v := data.XTopService; v != nil {
		req.Header.Set("X-Top-Service", *v)
	}
	if v := data.XTopRegion; v != nil {
		req.Header.Set("X-Top-Region", *v)
	}

	if v, ok := ctx.Value("K_LOGID").(string); ok {
		req.Header.Set("X-TT-LOGID", v)
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload FindGTMsResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) ModifyGTM(ctx context.Context, data *ModifyGTMRequest) error {
	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=ModifyGTM", nil)
	if err != nil {
		return err
	}

	q := req.URL.Query()
	if v := data.LbMode; v != nil {
		q.Add("lb_mode", *v)
	}
	if v := data.PrivInfo; v != nil {
		q.Add("priv_info", *v)
	}
	if v := data.Owner; v != nil {
		q.Add("owner", *v)
	}
	if v := data.ID; v != nil {
		q.Add("id", *v)
	}
	if v := data.Platform; v != nil {
		q.Add("platform", *v)
	}
	if v := data.AccMode; v != nil {
		q.Add("acc_mode", *v)
	}
	if v := data.LastOperator; v != nil {
		q.Add("last_operator", *v)
	}
	if v := data.Version; v != nil {
		q.Add("Version", *v)
	}
	if v := data.MaxServer; v != nil {
		q.Add("max_server", *v)
	}
	if v := data.Cname; v != nil {
		q.Add("cname", *v)
	}
	if v := data.AlarmOnly; v != nil {
		q.Add("alarm_only", *v)
	}
	if v := data.TTL; v != nil {
		q.Add("ttl", *v)
	}
	if v := data.AddrType; v != nil {
		q.Add("addr_type", *v)
	}
	if v := data.Domain; v != nil {
		q.Add("domain", *v)
	}
	if v := data.SchedMode; v != nil {
		q.Add("sched_mode", *v)
	}
	if v := data.FoMode; v != nil {
		q.Add("fo_mode", *v)
	}
	req.URL.RawQuery = q.Encode()

	if v := data.XTopAccountId; v != nil {
		req.Header.Set("X-Top-Account-Id", *v)
	}
	if v := data.XTopUserId; v != nil {
		req.Header.Set("X-Top-User-Id", *v)
	}
	if v := data.XTopRequestId; v != nil {
		req.Header.Set("X-Top-Request-Id", *v)
	}
	if v := data.XTopService; v != nil {
		req.Header.Set("X-Top-Service", *v)
	}
	if v := data.XTopRegion; v != nil {
		req.Header.Set("X-Top-Region", *v)
	}

	if v, ok := ctx.Value("K_LOGID").(string); ok {
		req.Header.Set("X-TT-LOGID", v)
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return err
	}
	defer resp.Body.Close()

	return nil
}

func (c *Client) ReadGTM(ctx context.Context, data *ReadGTMRequest) (*ReadGTMResponse, error) {
	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=ReadGTM", nil)
	if err != nil {
		return nil, err
	}

	q := req.URL.Query()
	if v := data.Version; v != nil {
		q.Add("Version", *v)
	}
	if v := data.ID; v != nil {
		q.Add("id", *v)
	}
	req.URL.RawQuery = q.Encode()

	if v := data.XTopAccountId; v != nil {
		req.Header.Set("X-Top-Account-Id", *v)
	}
	if v := data.XTopUserId; v != nil {
		req.Header.Set("X-Top-User-Id", *v)
	}
	if v := data.XTopRequestId; v != nil {
		req.Header.Set("X-Top-Request-Id", *v)
	}
	if v := data.XTopService; v != nil {
		req.Header.Set("X-Top-Service", *v)
	}
	if v := data.XTopRegion; v != nil {
		req.Header.Set("X-Top-Region", *v)
	}

	if v, ok := ctx.Value("K_LOGID").(string); ok {
		req.Header.Set("X-TT-LOGID", v)
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload ReadGTMResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) StartGTM(ctx context.Context, data *StartGTMRequest) error {
	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=StartGTM", nil)
	if err != nil {
		return err
	}

	q := req.URL.Query()
	if v := data.ID; v != nil {
		q.Add("id", *v)
	}
	if v := data.Version; v != nil {
		q.Add("Version", *v)
	}
	req.URL.RawQuery = q.Encode()

	if v := data.XTopAccountId; v != nil {
		req.Header.Set("X-Top-Account-Id", *v)
	}
	if v := data.XTopUserId; v != nil {
		req.Header.Set("X-Top-User-Id", *v)
	}
	if v := data.XTopRequestId; v != nil {
		req.Header.Set("X-Top-Request-Id", *v)
	}
	if v := data.XTopService; v != nil {
		req.Header.Set("X-Top-Service", *v)
	}
	if v := data.XTopRegion; v != nil {
		req.Header.Set("X-Top-Region", *v)
	}

	if v, ok := ctx.Value("K_LOGID").(string); ok {
		req.Header.Set("X-TT-LOGID", v)
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return err
	}
	defer resp.Body.Close()

	return nil
}

func (c *Client) StopGTM(ctx context.Context, data *StopGTMRequest) error {
	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=StopGTM", nil)
	if err != nil {
		return err
	}

	q := req.URL.Query()
	if v := data.ID; v != nil {
		q.Add("id", *v)
	}
	if v := data.Version; v != nil {
		q.Add("Version", *v)
	}
	req.URL.RawQuery = q.Encode()

	if v := data.XTopService; v != nil {
		req.Header.Set("X-Top-Service", *v)
	}
	if v := data.XTopRegion; v != nil {
		req.Header.Set("X-Top-Region", *v)
	}
	if v := data.XTopAccountId; v != nil {
		req.Header.Set("X-Top-Account-Id", *v)
	}
	if v := data.XTopUserId; v != nil {
		req.Header.Set("X-Top-User-Id", *v)
	}
	if v := data.XTopRequestId; v != nil {
		req.Header.Set("X-Top-Request-Id", *v)
	}

	if v, ok := ctx.Value("K_LOGID").(string); ok {
		req.Header.Set("X-TT-LOGID", v)
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return err
	}
	defer resp.Body.Close()

	return nil
}

// Group: GTM probe
// probe managerment

func (c *Client) ModifyProbe(ctx context.Context, data *ModifyProbeRequest) error {
	body, err := json.Marshal(data)
	if err != nil {
		return err
	}

	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=ModifyProbe", bytes.NewReader(body))
	if err != nil {
		return err
	}

	q := req.URL.Query()
	if v := data.Version; v != nil {
		q.Add("Version", *v)
	}
	if v := data.ID; v != nil {
		q.Add("id", *v)
	}
	req.URL.RawQuery = q.Encode()

	if v := data.XTopRegion; v != nil {
		req.Header.Set("X-Top-Region", *v)
	}
	if v := data.XTopAccountId; v != nil {
		req.Header.Set("X-Top-Account-Id", *v)
	}
	if v := data.XTopUserId; v != nil {
		req.Header.Set("X-Top-User-Id", *v)
	}
	if v := data.XTopRequestId; v != nil {
		req.Header.Set("X-Top-Request-Id", *v)
	}
	if v := data.XTopService; v != nil {
		req.Header.Set("X-Top-Service", *v)
	}

	if v, ok := ctx.Value("K_LOGID").(string); ok {
		req.Header.Set("X-TT-LOGID", v)
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return err
	}
	defer resp.Body.Close()

	return nil
}

func (c *Client) ReadProbe(ctx context.Context, data *ReadProbeRequest) (*ReadProbeResponse, error) {
	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=ReadProbe", nil)
	if err != nil {
		return nil, err
	}

	q := req.URL.Query()
	if v := data.ID; v != nil {
		q.Add("id", *v)
	}
	if v := data.Version; v != nil {
		q.Add("Version", *v)
	}
	req.URL.RawQuery = q.Encode()

	if v := data.XTopRequestId; v != nil {
		req.Header.Set("X-Top-Request-Id", *v)
	}
	if v := data.XTopService; v != nil {
		req.Header.Set("X-Top-Service", *v)
	}
	if v := data.XTopRegion; v != nil {
		req.Header.Set("X-Top-Region", *v)
	}
	if v := data.XTopAccountId; v != nil {
		req.Header.Set("X-Top-Account-Id", *v)
	}
	if v := data.XTopUserId; v != nil {
		req.Header.Set("X-Top-User-Id", *v)
	}

	if v, ok := ctx.Value("K_LOGID").(string); ok {
		req.Header.Set("X-TT-LOGID", v)
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload ReadProbeResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

// Group: GTM status
// statistics

func (c *Client) Stats(ctx context.Context, data *StatsRequest) (*StatsResponse, error) {
	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=Stats", nil)
	if err != nil {
		return nil, err
	}

	q := req.URL.Query()
	if v := data.Version; v != nil {
		q.Add("Version", *v)
	}
	req.URL.RawQuery = q.Encode()

	if v := data.XTopAccountId; v != nil {
		req.Header.Set("X-Top-Account-Id", *v)
	}
	if v := data.XTopUserId; v != nil {
		req.Header.Set("X-Top-User-Id", *v)
	}
	if v := data.XTopRequestId; v != nil {
		req.Header.Set("X-Top-Request-Id", *v)
	}
	if v := data.XTopService; v != nil {
		req.Header.Set("X-Top-Service", *v)
	}
	if v := data.XTopRegion; v != nil {
		req.Header.Set("X-Top-Region", *v)
	}

	if v, ok := ctx.Value("K_LOGID").(string); ok {
		req.Header.Set("X-TT-LOGID", v)
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload StatsResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

// Group: GTM view
// view managerment

func (c *Client) CreateView(ctx context.Context, data *CreateViewRequest) (*CreateViewResponse, error) {
	body, err := json.Marshal(data)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=CreateView", bytes.NewReader(body))
	if err != nil {
		return nil, err
	}

	q := req.URL.Query()
	if v := data.Version; v != nil {
		q.Add("Version", *v)
	}
	if v := data.ID; v != nil {
		q.Add("id", *v)
	}
	req.URL.RawQuery = q.Encode()

	if v := data.XTopRequestId; v != nil {
		req.Header.Set("X-Top-Request-Id", *v)
	}
	if v := data.XTopService; v != nil {
		req.Header.Set("X-Top-Service", *v)
	}
	if v := data.XTopRegion; v != nil {
		req.Header.Set("X-Top-Region", *v)
	}
	if v := data.XTopUserId; v != nil {
		req.Header.Set("X-Top-User-Id", *v)
	}
	if v := data.XTopAccountId; v != nil {
		req.Header.Set("X-Top-Account-Id", *v)
	}

	if v, ok := ctx.Value("K_LOGID").(string); ok {
		req.Header.Set("X-TT-LOGID", v)
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload CreateViewResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) DeleteView(ctx context.Context, data *DeleteViewRequest) error {
	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=DeleteView", nil)
	if err != nil {
		return err
	}

	q := req.URL.Query()
	if v := data.Version; v != nil {
		q.Add("Version", *v)
	}
	if v := data.ID; v != nil {
		q.Add("id", *v)
	}
	if v := data.Vid; v != nil {
		q.Add("vid", *v)
	}
	req.URL.RawQuery = q.Encode()

	if v := data.XTopUserId; v != nil {
		req.Header.Set("X-Top-User-Id", *v)
	}
	if v := data.XTopRequestId; v != nil {
		req.Header.Set("X-Top-Request-Id", *v)
	}
	if v := data.XTopService; v != nil {
		req.Header.Set("X-Top-Service", *v)
	}
	if v := data.XTopRegion; v != nil {
		req.Header.Set("X-Top-Region", *v)
	}
	if v := data.XTopAccountId; v != nil {
		req.Header.Set("X-Top-Account-Id", *v)
	}

	if v, ok := ctx.Value("K_LOGID").(string); ok {
		req.Header.Set("X-TT-LOGID", v)
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return err
	}
	defer resp.Body.Close()

	return nil
}

func (c *Client) ListViews(ctx context.Context, data *ListViewsRequest) (ListViewsResponse, error) {
	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=ListViews", nil)
	if err != nil {
		return nil, err
	}

	q := req.URL.Query()
	if v := data.Name; v != nil {
		q.Add("name", *v)
	}
	if v := data.Line; v != nil {
		q.Add("line", *v)
	}
	if v := data.Version; v != nil {
		q.Add("Version", *v)
	}
	if v := data.ID; v != nil {
		q.Add("id", *v)
	}
	req.URL.RawQuery = q.Encode()

	if v := data.XTopRequestId; v != nil {
		req.Header.Set("X-Top-Request-Id", *v)
	}
	if v := data.XTopService; v != nil {
		req.Header.Set("X-Top-Service", *v)
	}
	if v := data.XTopRegion; v != nil {
		req.Header.Set("X-Top-Region", *v)
	}
	if v := data.XTopAccountId; v != nil {
		req.Header.Set("X-Top-Account-Id", *v)
	}
	if v := data.XTopUserId; v != nil {
		req.Header.Set("X-Top-User-Id", *v)
	}

	if v, ok := ctx.Value("K_LOGID").(string); ok {
		req.Header.Set("X-TT-LOGID", v)
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload ListViewsResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return payload, nil
}

func (c *Client) ModifyView(ctx context.Context, data *ModifyViewRequest) error {
	body, err := json.Marshal(data)
	if err != nil {
		return err
	}

	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=ModifyView", bytes.NewReader(body))
	if err != nil {
		return err
	}

	q := req.URL.Query()
	if v := data.Vid; v != nil {
		q.Add("vid", *v)
	}
	if v := data.Version; v != nil {
		q.Add("Version", *v)
	}
	if v := data.ID; v != nil {
		q.Add("id", *v)
	}
	req.URL.RawQuery = q.Encode()

	if v := data.XTopRegion; v != nil {
		req.Header.Set("X-Top-Region", *v)
	}
	if v := data.XTopAccountId; v != nil {
		req.Header.Set("X-Top-Account-Id", *v)
	}
	if v := data.XTopUserId; v != nil {
		req.Header.Set("X-Top-User-Id", *v)
	}
	if v := data.XTopRequestId; v != nil {
		req.Header.Set("X-Top-Request-Id", *v)
	}
	if v := data.XTopService; v != nil {
		req.Header.Set("X-Top-Service", *v)
	}

	if v, ok := ctx.Value("K_LOGID").(string); ok {
		req.Header.Set("X-TT-LOGID", v)
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return err
	}
	defer resp.Body.Close()

	return nil
}

func (c *Client) ReadView(ctx context.Context, data *ReadViewRequest) (*ReadViewResponse, error) {
	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=ReadView", nil)
	if err != nil {
		return nil, err
	}

	q := req.URL.Query()
	if v := data.Version; v != nil {
		q.Add("Version", *v)
	}
	if v := data.ID; v != nil {
		q.Add("id", *v)
	}
	if v := data.Vid; v != nil {
		q.Add("vid", *v)
	}
	req.URL.RawQuery = q.Encode()

	if v := data.XTopService; v != nil {
		req.Header.Set("X-Top-Service", *v)
	}
	if v := data.XTopRegion; v != nil {
		req.Header.Set("X-Top-Region", *v)
	}
	if v := data.XTopAccountId; v != nil {
		req.Header.Set("X-Top-Account-Id", *v)
	}
	if v := data.XTopUserId; v != nil {
		req.Header.Set("X-Top-User-Id", *v)
	}
	if v := data.XTopRequestId; v != nil {
		req.Header.Set("X-Top-Request-Id", *v)
	}

	if v, ok := ctx.Value("K_LOGID").(string); ok {
		req.Header.Set("X-TT-LOGID", v)
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload ReadViewResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}
