package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTrainTasks invokes the viapi_regen.ListTrainTasks API synchronously
func (client *Client) ListTrainTasks(request *ListTrainTasksRequest) (response *ListTrainTasksResponse, err error) {
	response = CreateListTrainTasksResponse()
	err = client.DoAction(request, response)
	return
}

// ListTrainTasksWithChan invokes the viapi_regen.ListTrainTasks API asynchronously
func (client *Client) ListTrainTasksWithChan(request *ListTrainTasksRequest) (<-chan *ListTrainTasksResponse, <-chan error) {
	responseChan := make(chan *ListTrainTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTrainTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTrainTasksWithCallback invokes the viapi_regen.ListTrainTasks API asynchronously
func (client *Client) ListTrainTasksWithCallback(request *ListTrainTasksRequest, callback func(response *ListTrainTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTrainTasksResponse
		var err error
		defer close(result)
		response, err = client.ListTrainTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTrainTasksRequest is the request struct for api ListTrainTasks
type ListTrainTasksRequest struct {
	*requests.RpcRequest
	PageSize    requests.Integer `position:"Body" name:"PageSize"`
	CurrentPage requests.Integer `position:"Body" name:"CurrentPage"`
	Status      string           `position:"Body" name:"Status"`
	WorkspaceId requests.Integer `position:"Body" name:"WorkspaceId"`
}

// ListTrainTasksResponse is the response struct for api ListTrainTasks
type ListTrainTasksResponse struct {
	*responses.BaseResponse
	Message   string               `json:"Message" xml:"Message"`
	RequestId string               `json:"RequestId" xml:"RequestId"`
	Code      string               `json:"Code" xml:"Code"`
	Data      DataInListTrainTasks `json:"Data" xml:"Data"`
}

// CreateListTrainTasksRequest creates a request to invoke ListTrainTasks API
func CreateListTrainTasksRequest() (request *ListTrainTasksRequest) {
	request = &ListTrainTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "ListTrainTasks", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListTrainTasksResponse creates a response to parse from ListTrainTasks response
func CreateListTrainTasksResponse() (response *ListTrainTasksResponse) {
	response = &ListTrainTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
