package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConvertImageToGray invokes the trademark.ConvertImageToGray API synchronously
// api document: https://help.aliyun.com/api/trademark/convertimagetogray.html
func (client *Client) ConvertImageToGray(request *ConvertImageToGrayRequest) (response *ConvertImageToGrayResponse, err error) {
	response = CreateConvertImageToGrayResponse()
	err = client.DoAction(request, response)
	return
}

// ConvertImageToGrayWithChan invokes the trademark.ConvertImageToGray API asynchronously
// api document: https://help.aliyun.com/api/trademark/convertimagetogray.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ConvertImageToGrayWithChan(request *ConvertImageToGrayRequest) (<-chan *ConvertImageToGrayResponse, <-chan error) {
	responseChan := make(chan *ConvertImageToGrayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConvertImageToGray(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConvertImageToGrayWithCallback invokes the trademark.ConvertImageToGray API asynchronously
// api document: https://help.aliyun.com/api/trademark/convertimagetogray.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ConvertImageToGrayWithCallback(request *ConvertImageToGrayRequest, callback func(response *ConvertImageToGrayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConvertImageToGrayResponse
		var err error
		defer close(result)
		response, err = client.ConvertImageToGray(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConvertImageToGrayRequest is the request struct for api ConvertImageToGray
type ConvertImageToGrayRequest struct {
	*requests.RpcRequest
	OssKey string `position:"Query" name:"OssKey"`
}

// ConvertImageToGrayResponse is the response struct for api ConvertImageToGray
type ConvertImageToGrayResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	SignatureUrl string `json:"SignatureUrl" xml:"SignatureUrl"`
}

// CreateConvertImageToGrayRequest creates a request to invoke ConvertImageToGray API
func CreateConvertImageToGrayRequest() (request *ConvertImageToGrayRequest) {
	request = &ConvertImageToGrayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "ConvertImageToGray", "trademark", "openAPI")
	return
}

// CreateConvertImageToGrayResponse creates a response to parse from ConvertImageToGray response
func CreateConvertImageToGrayResponse() (response *ConvertImageToGrayResponse) {
	response = &ConvertImageToGrayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
