package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ValidateGatewayName invokes the sgw.ValidateGatewayName API synchronously
func (client *Client) ValidateGatewayName(request *ValidateGatewayNameRequest) (response *ValidateGatewayNameResponse, err error) {
	response = CreateValidateGatewayNameResponse()
	err = client.DoAction(request, response)
	return
}

// ValidateGatewayNameWithChan invokes the sgw.ValidateGatewayName API asynchronously
func (client *Client) ValidateGatewayNameWithChan(request *ValidateGatewayNameRequest) (<-chan *ValidateGatewayNameResponse, <-chan error) {
	responseChan := make(chan *ValidateGatewayNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ValidateGatewayName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ValidateGatewayNameWithCallback invokes the sgw.ValidateGatewayName API asynchronously
func (client *Client) ValidateGatewayNameWithCallback(request *ValidateGatewayNameRequest, callback func(response *ValidateGatewayNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ValidateGatewayNameResponse
		var err error
		defer close(result)
		response, err = client.ValidateGatewayName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ValidateGatewayNameRequest is the request struct for api ValidateGatewayName
type ValidateGatewayNameRequest struct {
	*requests.RpcRequest
	Name            string `position:"Query" name:"Name"`
	StorageBundleId string `position:"Query" name:"StorageBundleId"`
}

// ValidateGatewayNameResponse is the response struct for api ValidateGatewayName
type ValidateGatewayNameResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	IsValid   bool   `json:"IsValid" xml:"IsValid"`
}

// CreateValidateGatewayNameRequest creates a request to invoke ValidateGatewayName API
func CreateValidateGatewayNameRequest() (request *ValidateGatewayNameRequest) {
	request = &ValidateGatewayNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "ValidateGatewayName", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateValidateGatewayNameResponse creates a response to parse from ValidateGatewayName response
func CreateValidateGatewayNameResponse() (response *ValidateGatewayNameResponse) {
	response = &ValidateGatewayNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
