package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWebLockConfigList invokes the sas.DescribeWebLockConfigList API synchronously
func (client *Client) DescribeWebLockConfigList(request *DescribeWebLockConfigListRequest) (response *DescribeWebLockConfigListResponse, err error) {
	response = CreateDescribeWebLockConfigListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWebLockConfigListWithChan invokes the sas.DescribeWebLockConfigList API asynchronously
func (client *Client) DescribeWebLockConfigListWithChan(request *DescribeWebLockConfigListRequest) (<-chan *DescribeWebLockConfigListResponse, <-chan error) {
	responseChan := make(chan *DescribeWebLockConfigListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWebLockConfigList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWebLockConfigListWithCallback invokes the sas.DescribeWebLockConfigList API asynchronously
func (client *Client) DescribeWebLockConfigListWithCallback(request *DescribeWebLockConfigListRequest, callback func(response *DescribeWebLockConfigListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWebLockConfigListResponse
		var err error
		defer close(result)
		response, err = client.DescribeWebLockConfigList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWebLockConfigListRequest is the request struct for api DescribeWebLockConfigList
type DescribeWebLockConfigListRequest struct {
	*requests.RpcRequest
	Uuid     string `position:"Query" name:"Uuid"`
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribeWebLockConfigListResponse is the response struct for api DescribeWebLockConfigList
type DescribeWebLockConfigListResponse struct {
	*responses.BaseResponse
	TotalCount int          `json:"TotalCount" xml:"TotalCount"`
	RequestId  string       `json:"RequestId" xml:"RequestId"`
	ConfigList []ConfigInfo `json:"ConfigList" xml:"ConfigList"`
}

// CreateDescribeWebLockConfigListRequest creates a request to invoke DescribeWebLockConfigList API
func CreateDescribeWebLockConfigListRequest() (request *DescribeWebLockConfigListRequest) {
	request = &DescribeWebLockConfigListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeWebLockConfigList", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeWebLockConfigListResponse creates a response to parse from DescribeWebLockConfigList response
func CreateDescribeWebLockConfigListResponse() (response *DescribeWebLockConfigListResponse) {
	response = &DescribeWebLockConfigListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
