package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceRebootStatus invokes the sas.DescribeInstanceRebootStatus API synchronously
func (client *Client) DescribeInstanceRebootStatus(request *DescribeInstanceRebootStatusRequest) (response *DescribeInstanceRebootStatusResponse, err error) {
	response = CreateDescribeInstanceRebootStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceRebootStatusWithChan invokes the sas.DescribeInstanceRebootStatus API asynchronously
func (client *Client) DescribeInstanceRebootStatusWithChan(request *DescribeInstanceRebootStatusRequest) (<-chan *DescribeInstanceRebootStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceRebootStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceRebootStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceRebootStatusWithCallback invokes the sas.DescribeInstanceRebootStatus API asynchronously
func (client *Client) DescribeInstanceRebootStatusWithCallback(request *DescribeInstanceRebootStatusRequest, callback func(response *DescribeInstanceRebootStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceRebootStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceRebootStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceRebootStatusRequest is the request struct for api DescribeInstanceRebootStatus
type DescribeInstanceRebootStatusRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Uuids    string `position:"Query" name:"Uuids"`
}

// DescribeInstanceRebootStatusResponse is the response struct for api DescribeInstanceRebootStatus
type DescribeInstanceRebootStatusResponse struct {
	*responses.BaseResponse
	TotalCount     int            `json:"TotalCount" xml:"TotalCount"`
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	RebootStatuses []RebootStatus `json:"RebootStatuses" xml:"RebootStatuses"`
}

// CreateDescribeInstanceRebootStatusRequest creates a request to invoke DescribeInstanceRebootStatus API
func CreateDescribeInstanceRebootStatusRequest() (request *DescribeInstanceRebootStatusRequest) {
	request = &DescribeInstanceRebootStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeInstanceRebootStatus", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceRebootStatusResponse creates a response to parse from DescribeInstanceRebootStatus response
func CreateDescribeInstanceRebootStatusResponse() (response *DescribeInstanceRebootStatusResponse) {
	response = &DescribeInstanceRebootStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
