package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeApps invokes the rtc.DescribeApps API synchronously
func (client *Client) DescribeApps(request *DescribeAppsRequest) (response *DescribeAppsResponse, err error) {
	response = CreateDescribeAppsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAppsWithChan invokes the rtc.DescribeApps API asynchronously
func (client *Client) DescribeAppsWithChan(request *DescribeAppsRequest) (<-chan *DescribeAppsResponse, <-chan error) {
	responseChan := make(chan *DescribeAppsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeApps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAppsWithCallback invokes the rtc.DescribeApps API asynchronously
func (client *Client) DescribeAppsWithCallback(request *DescribeAppsRequest, callback func(response *DescribeAppsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAppsResponse
		var err error
		defer close(result)
		response, err = client.DescribeApps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAppsRequest is the request struct for api DescribeApps
type DescribeAppsRequest struct {
	*requests.RpcRequest
	PageNum  requests.Integer `position:"Query" name:"PageNum"`
	PageSize requests.Integer `position:"Query" name:"PageSize"`
	ShowLog  string           `position:"Query" name:"ShowLog"`
	Order    string           `position:"Query" name:"Order"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
	AppId    string           `position:"Query" name:"AppId"`
	Status   string           `position:"Query" name:"Status"`
}

// DescribeAppsResponse is the response struct for api DescribeApps
type DescribeAppsResponse struct {
	*responses.BaseResponse
	TotalPage int     `json:"TotalPage" xml:"TotalPage"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	TotalNum  int     `json:"TotalNum" xml:"TotalNum"`
	AppList   AppList `json:"AppList" xml:"AppList"`
}

// CreateDescribeAppsRequest creates a request to invoke DescribeApps API
func CreateDescribeAppsRequest() (request *DescribeAppsRequest) {
	request = &DescribeAppsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DescribeApps", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeAppsResponse creates a response to parse from DescribeApps response
func CreateDescribeAppsResponse() (response *DescribeAppsResponse) {
	response = &DescribeAppsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
