package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteADSetting invokes the rds.DeleteADSetting API synchronously
func (client *Client) DeleteADSetting(request *DeleteADSettingRequest) (response *DeleteADSettingResponse, err error) {
	response = CreateDeleteADSettingResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteADSettingWithChan invokes the rds.DeleteADSetting API asynchronously
func (client *Client) DeleteADSettingWithChan(request *DeleteADSettingRequest) (<-chan *DeleteADSettingResponse, <-chan error) {
	responseChan := make(chan *DeleteADSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteADSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteADSettingWithCallback invokes the rds.DeleteADSetting API asynchronously
func (client *Client) DeleteADSettingWithCallback(request *DeleteADSettingRequest, callback func(response *DeleteADSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteADSettingResponse
		var err error
		defer close(result)
		response, err = client.DeleteADSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteADSettingRequest is the request struct for api DeleteADSetting
type DeleteADSettingRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
}

// DeleteADSettingResponse is the response struct for api DeleteADSetting
type DeleteADSettingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteADSettingRequest creates a request to invoke DeleteADSetting API
func CreateDeleteADSettingRequest() (request *DeleteADSettingRequest) {
	request = &DeleteADSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DeleteADSetting", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteADSettingResponse creates a response to parse from DeleteADSetting response
func CreateDeleteADSettingResponse() (response *DeleteADSettingResponse) {
	response = &DeleteADSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
