package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateQualityCheckScheme invokes the qualitycheck.UpdateQualityCheckScheme API synchronously
func (client *Client) UpdateQualityCheckScheme(request *UpdateQualityCheckSchemeRequest) (response *UpdateQualityCheckSchemeResponse, err error) {
	response = CreateUpdateQualityCheckSchemeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateQualityCheckSchemeWithChan invokes the qualitycheck.UpdateQualityCheckScheme API asynchronously
func (client *Client) UpdateQualityCheckSchemeWithChan(request *UpdateQualityCheckSchemeRequest) (<-chan *UpdateQualityCheckSchemeResponse, <-chan error) {
	responseChan := make(chan *UpdateQualityCheckSchemeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateQualityCheckScheme(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateQualityCheckSchemeWithCallback invokes the qualitycheck.UpdateQualityCheckScheme API asynchronously
func (client *Client) UpdateQualityCheckSchemeWithCallback(request *UpdateQualityCheckSchemeRequest, callback func(response *UpdateQualityCheckSchemeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateQualityCheckSchemeResponse
		var err error
		defer close(result)
		response, err = client.UpdateQualityCheckScheme(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateQualityCheckSchemeRequest is the request struct for api UpdateQualityCheckScheme
type UpdateQualityCheckSchemeRequest struct {
	*requests.RpcRequest
	JsonStr       string           `position:"Query" name:"jsonStr"`
	BaseMeAgentId requests.Integer `position:"Query" name:"BaseMeAgentId"`
}

// UpdateQualityCheckSchemeResponse is the response struct for api UpdateQualityCheckScheme
type UpdateQualityCheckSchemeResponse struct {
	*responses.BaseResponse
	RequestId      string                             `json:"RequestId" xml:"RequestId"`
	Success        bool                               `json:"Success" xml:"Success"`
	Code           string                             `json:"Code" xml:"Code"`
	Message        string                             `json:"Message" xml:"Message"`
	HttpStatusCode int                                `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Messages       MessagesInUpdateQualityCheckScheme `json:"Messages" xml:"Messages"`
}

// CreateUpdateQualityCheckSchemeRequest creates a request to invoke UpdateQualityCheckScheme API
func CreateUpdateQualityCheckSchemeRequest() (request *UpdateQualityCheckSchemeRequest) {
	request = &UpdateQualityCheckSchemeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "UpdateQualityCheckScheme", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateQualityCheckSchemeResponse creates a response to parse from UpdateQualityCheckScheme response
func CreateUpdateQualityCheckSchemeResponse() (response *UpdateQualityCheckSchemeResponse) {
	response = &UpdateQualityCheckSchemeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
