package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOpenJMeterScene invokes the pts.GetOpenJMeterScene API synchronously
func (client *Client) GetOpenJMeterScene(request *GetOpenJMeterSceneRequest) (response *GetOpenJMeterSceneResponse, err error) {
	response = CreateGetOpenJMeterSceneResponse()
	err = client.DoAction(request, response)
	return
}

// GetOpenJMeterSceneWithChan invokes the pts.GetOpenJMeterScene API asynchronously
func (client *Client) GetOpenJMeterSceneWithChan(request *GetOpenJMeterSceneRequest) (<-chan *GetOpenJMeterSceneResponse, <-chan error) {
	responseChan := make(chan *GetOpenJMeterSceneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOpenJMeterScene(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOpenJMeterSceneWithCallback invokes the pts.GetOpenJMeterScene API asynchronously
func (client *Client) GetOpenJMeterSceneWithCallback(request *GetOpenJMeterSceneRequest, callback func(response *GetOpenJMeterSceneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOpenJMeterSceneResponse
		var err error
		defer close(result)
		response, err = client.GetOpenJMeterScene(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOpenJMeterSceneRequest is the request struct for api GetOpenJMeterScene
type GetOpenJMeterSceneRequest struct {
	*requests.RpcRequest
	SceneId string `position:"Query" name:"SceneId"`
}

// GetOpenJMeterSceneResponse is the response struct for api GetOpenJMeterScene
type GetOpenJMeterSceneResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Scene          Scene  `json:"Scene" xml:"Scene"`
}

// CreateGetOpenJMeterSceneRequest creates a request to invoke GetOpenJMeterScene API
func CreateGetOpenJMeterSceneRequest() (request *GetOpenJMeterSceneRequest) {
	request = &GetOpenJMeterSceneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2020-10-20", "GetOpenJMeterScene", "", "")
	request.Method = requests.POST
	return
}

// CreateGetOpenJMeterSceneResponse creates a response to parse from GetOpenJMeterScene response
func CreateGetOpenJMeterSceneResponse() (response *GetOpenJMeterSceneResponse) {
	response = &GetOpenJMeterSceneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
