package privatelink

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveZoneFromVpcEndpoint invokes the privatelink.RemoveZoneFromVpcEndpoint API synchronously
func (client *Client) RemoveZoneFromVpcEndpoint(request *RemoveZoneFromVpcEndpointRequest) (response *RemoveZoneFromVpcEndpointResponse, err error) {
	response = CreateRemoveZoneFromVpcEndpointResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveZoneFromVpcEndpointWithChan invokes the privatelink.RemoveZoneFromVpcEndpoint API asynchronously
func (client *Client) RemoveZoneFromVpcEndpointWithChan(request *RemoveZoneFromVpcEndpointRequest) (<-chan *RemoveZoneFromVpcEndpointResponse, <-chan error) {
	responseChan := make(chan *RemoveZoneFromVpcEndpointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveZoneFromVpcEndpoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveZoneFromVpcEndpointWithCallback invokes the privatelink.RemoveZoneFromVpcEndpoint API asynchronously
func (client *Client) RemoveZoneFromVpcEndpointWithCallback(request *RemoveZoneFromVpcEndpointRequest, callback func(response *RemoveZoneFromVpcEndpointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveZoneFromVpcEndpointResponse
		var err error
		defer close(result)
		response, err = client.RemoveZoneFromVpcEndpoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveZoneFromVpcEndpointRequest is the request struct for api RemoveZoneFromVpcEndpoint
type RemoveZoneFromVpcEndpointRequest struct {
	*requests.RpcRequest
	ClientToken string           `position:"Query" name:"ClientToken"`
	EndpointId  string           `position:"Query" name:"EndpointId"`
	DryRun      requests.Boolean `position:"Query" name:"DryRun"`
	ZoneId      string           `position:"Query" name:"ZoneId"`
}

// RemoveZoneFromVpcEndpointResponse is the response struct for api RemoveZoneFromVpcEndpoint
type RemoveZoneFromVpcEndpointResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRemoveZoneFromVpcEndpointRequest creates a request to invoke RemoveZoneFromVpcEndpoint API
func CreateRemoveZoneFromVpcEndpointRequest() (request *RemoveZoneFromVpcEndpointRequest) {
	request = &RemoveZoneFromVpcEndpointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Privatelink", "2020-04-15", "RemoveZoneFromVpcEndpoint", "privatelink", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveZoneFromVpcEndpointResponse creates a response to parse from RemoveZoneFromVpcEndpoint response
func CreateRemoveZoneFromVpcEndpointResponse() (response *RemoveZoneFromVpcEndpointResponse) {
	response = &RemoveZoneFromVpcEndpointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
