package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteScriptRecording invokes the outboundbot.DeleteScriptRecording API synchronously
func (client *Client) DeleteScriptRecording(request *DeleteScriptRecordingRequest) (response *DeleteScriptRecordingResponse, err error) {
	response = CreateDeleteScriptRecordingResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteScriptRecordingWithChan invokes the outboundbot.DeleteScriptRecording API asynchronously
func (client *Client) DeleteScriptRecordingWithChan(request *DeleteScriptRecordingRequest) (<-chan *DeleteScriptRecordingResponse, <-chan error) {
	responseChan := make(chan *DeleteScriptRecordingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteScriptRecording(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteScriptRecordingWithCallback invokes the outboundbot.DeleteScriptRecording API asynchronously
func (client *Client) DeleteScriptRecordingWithCallback(request *DeleteScriptRecordingRequest, callback func(response *DeleteScriptRecordingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteScriptRecordingResponse
		var err error
		defer close(result)
		response, err = client.DeleteScriptRecording(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteScriptRecordingRequest is the request struct for api DeleteScriptRecording
type DeleteScriptRecordingRequest struct {
	*requests.RpcRequest
	UuidsJson  string `position:"Query" name:"UuidsJson"`
	ScriptId   string `position:"Query" name:"ScriptId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DeleteScriptRecordingResponse is the response struct for api DeleteScriptRecording
type DeleteScriptRecordingResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateDeleteScriptRecordingRequest creates a request to invoke DeleteScriptRecording API
func CreateDeleteScriptRecordingRequest() (request *DeleteScriptRecordingRequest) {
	request = &DeleteScriptRecordingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "DeleteScriptRecording", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteScriptRecordingResponse creates a response to parse from DeleteScriptRecording response
func CreateDeleteScriptRecordingResponse() (response *DeleteScriptRecordingResponse) {
	response = &DeleteScriptRecordingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
