package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSecretParameters invokes the oos.GetSecretParameters API synchronously
func (client *Client) GetSecretParameters(request *GetSecretParametersRequest) (response *GetSecretParametersResponse, err error) {
	response = CreateGetSecretParametersResponse()
	err = client.DoAction(request, response)
	return
}

// GetSecretParametersWithChan invokes the oos.GetSecretParameters API asynchronously
func (client *Client) GetSecretParametersWithChan(request *GetSecretParametersRequest) (<-chan *GetSecretParametersResponse, <-chan error) {
	responseChan := make(chan *GetSecretParametersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSecretParameters(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSecretParametersWithCallback invokes the oos.GetSecretParameters API asynchronously
func (client *Client) GetSecretParametersWithCallback(request *GetSecretParametersRequest, callback func(response *GetSecretParametersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSecretParametersResponse
		var err error
		defer close(result)
		response, err = client.GetSecretParameters(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSecretParametersRequest is the request struct for api GetSecretParameters
type GetSecretParametersRequest struct {
	*requests.RpcRequest
	WithDecryption requests.Boolean `position:"Query" name:"WithDecryption"`
	Names          string           `position:"Query" name:"Names"`
}

// GetSecretParametersResponse is the response struct for api GetSecretParameters
type GetSecretParametersResponse struct {
	*responses.BaseResponse
	RequestId         string      `json:"RequestId" xml:"RequestId"`
	InvalidParameters []string    `json:"InvalidParameters" xml:"InvalidParameters"`
	Parameters        []Parameter `json:"Parameters" xml:"Parameters"`
}

// CreateGetSecretParametersRequest creates a request to invoke GetSecretParameters API
func CreateGetSecretParametersRequest() (request *GetSecretParametersRequest) {
	request = &GetSecretParametersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "GetSecretParameters", "oos", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetSecretParametersResponse creates a response to parse from GetSecretParameters response
func CreateGetSecretParametersResponse() (response *GetSecretParametersResponse) {
	response = &GetSecretParametersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
