package oms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetIncrementMeasureDataByProxy invokes the oms.GetIncrementMeasureDataByProxy API synchronously
func (client *Client) GetIncrementMeasureDataByProxy(request *GetIncrementMeasureDataByProxyRequest) (response *GetIncrementMeasureDataByProxyResponse, err error) {
	response = CreateGetIncrementMeasureDataByProxyResponse()
	err = client.DoAction(request, response)
	return
}

// GetIncrementMeasureDataByProxyWithChan invokes the oms.GetIncrementMeasureDataByProxy API asynchronously
func (client *Client) GetIncrementMeasureDataByProxyWithChan(request *GetIncrementMeasureDataByProxyRequest) (<-chan *GetIncrementMeasureDataByProxyResponse, <-chan error) {
	responseChan := make(chan *GetIncrementMeasureDataByProxyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetIncrementMeasureDataByProxy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetIncrementMeasureDataByProxyWithCallback invokes the oms.GetIncrementMeasureDataByProxy API asynchronously
func (client *Client) GetIncrementMeasureDataByProxyWithCallback(request *GetIncrementMeasureDataByProxyRequest, callback func(response *GetIncrementMeasureDataByProxyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetIncrementMeasureDataByProxyResponse
		var err error
		defer close(result)
		response, err = client.GetIncrementMeasureDataByProxy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetIncrementMeasureDataByProxyRequest is the request struct for api GetIncrementMeasureDataByProxy
type GetIncrementMeasureDataByProxyRequest struct {
	*requests.RpcRequest
	DomainCode      string           `position:"Query" name:"DomainCode"`
	ModifyEndTime   requests.Integer `position:"Query" name:"ModifyEndTime"`
	DataType        string           `position:"Query" name:"DataType"`
	CompressEnable  requests.Boolean `position:"Query" name:"CompressEnable"`
	RowKeyMapStr    string           `position:"Query" name:"RowKeyMapStr"`
	ModifyStartTime requests.Integer `position:"Query" name:"ModifyStartTime"`
}

// GetIncrementMeasureDataByProxyResponse is the response struct for api GetIncrementMeasureDataByProxy
type GetIncrementMeasureDataByProxyResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	DomainCode string `json:"DomainCode" xml:"DomainCode"`
	DataType   string `json:"DataType" xml:"DataType"`
	Data       string `json:"Data" xml:"Data"`
	Compressed string `json:"Compressed" xml:"Compressed"`
}

// CreateGetIncrementMeasureDataByProxyRequest creates a request to invoke GetIncrementMeasureDataByProxy API
func CreateGetIncrementMeasureDataByProxyRequest() (request *GetIncrementMeasureDataByProxyRequest) {
	request = &GetIncrementMeasureDataByProxyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oms", "2016-06-15", "GetIncrementMeasureDataByProxy", "", "")
	request.Method = requests.GET
	return
}

// CreateGetIncrementMeasureDataByProxyResponse creates a response to parse from GetIncrementMeasureDataByProxy response
func CreateGetIncrementMeasureDataByProxyResponse() (response *GetIncrementMeasureDataByProxyResponse) {
	response = &GetIncrementMeasureDataByProxyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
