package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSQLSamples invokes the oceanbasepro.DescribeSQLSamples API synchronously
func (client *Client) DescribeSQLSamples(request *DescribeSQLSamplesRequest) (response *DescribeSQLSamplesResponse, err error) {
	response = CreateDescribeSQLSamplesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSQLSamplesWithChan invokes the oceanbasepro.DescribeSQLSamples API asynchronously
func (client *Client) DescribeSQLSamplesWithChan(request *DescribeSQLSamplesRequest) (<-chan *DescribeSQLSamplesResponse, <-chan error) {
	responseChan := make(chan *DescribeSQLSamplesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSQLSamples(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSQLSamplesWithCallback invokes the oceanbasepro.DescribeSQLSamples API asynchronously
func (client *Client) DescribeSQLSamplesWithCallback(request *DescribeSQLSamplesRequest, callback func(response *DescribeSQLSamplesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSQLSamplesResponse
		var err error
		defer close(result)
		response, err = client.DescribeSQLSamples(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSQLSamplesRequest is the request struct for api DescribeSQLSamples
type DescribeSQLSamplesRequest struct {
	*requests.RpcRequest
	ReturnSqlText requests.Boolean `position:"Body" name:"ReturnSqlText"`
	StartTime     string           `position:"Body" name:"StartTime"`
	TenantId      string           `position:"Body" name:"TenantId"`
	SqlId         string           `position:"Body" name:"SqlId"`
	EndTime       string           `position:"Body" name:"EndTime"`
	InstanceId    string           `position:"Body" name:"InstanceId"`
	DbName        string           `position:"Body" name:"DbName"`
}

// DescribeSQLSamplesResponse is the response struct for api DescribeSQLSamples
type DescribeSQLSamplesResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeSQLSamplesRequest creates a request to invoke DescribeSQLSamples API
func CreateDescribeSQLSamplesRequest() (request *DescribeSQLSamplesRequest) {
	request = &DescribeSQLSamplesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeSQLSamples", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSQLSamplesResponse creates a response to parse from DescribeSQLSamples response
func CreateDescribeSQLSamplesResponse() (response *DescribeSQLSamplesResponse) {
	response = &DescribeSQLSamplesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
