package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCustomEntity invokes the mts.DeleteCustomEntity API synchronously
func (client *Client) DeleteCustomEntity(request *DeleteCustomEntityRequest) (response *DeleteCustomEntityResponse, err error) {
	response = CreateDeleteCustomEntityResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCustomEntityWithChan invokes the mts.DeleteCustomEntity API asynchronously
func (client *Client) DeleteCustomEntityWithChan(request *DeleteCustomEntityRequest) (<-chan *DeleteCustomEntityResponse, <-chan error) {
	responseChan := make(chan *DeleteCustomEntityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCustomEntity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCustomEntityWithCallback invokes the mts.DeleteCustomEntity API asynchronously
func (client *Client) DeleteCustomEntityWithCallback(request *DeleteCustomEntityRequest, callback func(response *DeleteCustomEntityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCustomEntityResponse
		var err error
		defer close(result)
		response, err = client.DeleteCustomEntity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCustomEntityRequest is the request struct for api DeleteCustomEntity
type DeleteCustomEntityRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Algorithm            string           `position:"Query" name:"Algorithm"`
	CustomGroupId        string           `position:"Query" name:"CustomGroupId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	CustomEntityId       string           `position:"Query" name:"CustomEntityId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteCustomEntityResponse is the response struct for api DeleteCustomEntity
type DeleteCustomEntityResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteCustomEntityRequest creates a request to invoke DeleteCustomEntity API
func CreateDeleteCustomEntityRequest() (request *DeleteCustomEntityRequest) {
	request = &DeleteCustomEntityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "DeleteCustomEntity", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteCustomEntityResponse creates a response to parse from DeleteCustomEntity response
func CreateDeleteCustomEntityResponse() (response *DeleteCustomEntityResponse) {
	response = &DeleteCustomEntityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
