package market

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeProjectAttachments invokes the market.DescribeProjectAttachments API synchronously
func (client *Client) DescribeProjectAttachments(request *DescribeProjectAttachmentsRequest) (response *DescribeProjectAttachmentsResponse, err error) {
	response = CreateDescribeProjectAttachmentsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeProjectAttachmentsWithChan invokes the market.DescribeProjectAttachments API asynchronously
func (client *Client) DescribeProjectAttachmentsWithChan(request *DescribeProjectAttachmentsRequest) (<-chan *DescribeProjectAttachmentsResponse, <-chan error) {
	responseChan := make(chan *DescribeProjectAttachmentsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeProjectAttachments(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeProjectAttachmentsWithCallback invokes the market.DescribeProjectAttachments API asynchronously
func (client *Client) DescribeProjectAttachmentsWithCallback(request *DescribeProjectAttachmentsRequest, callback func(response *DescribeProjectAttachmentsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeProjectAttachmentsResponse
		var err error
		defer close(result)
		response, err = client.DescribeProjectAttachments(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeProjectAttachmentsRequest is the request struct for api DescribeProjectAttachments
type DescribeProjectAttachmentsRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DescribeProjectAttachmentsResponse is the response struct for api DescribeProjectAttachments
type DescribeProjectAttachmentsResponse struct {
	*responses.BaseResponse
	Success   bool                `json:"Success" xml:"Success"`
	RequestId string              `json:"RequestId" xml:"RequestId"`
	Result    []ProjectAttachment `json:"Result" xml:"Result"`
}

// CreateDescribeProjectAttachmentsRequest creates a request to invoke DescribeProjectAttachments API
func CreateDescribeProjectAttachmentsRequest() (request *DescribeProjectAttachmentsRequest) {
	request = &DescribeProjectAttachmentsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Market", "2015-11-01", "DescribeProjectAttachments", "yunmarket", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeProjectAttachmentsResponse creates a response to parse from DescribeProjectAttachments response
func CreateDescribeProjectAttachmentsResponse() (response *DescribeProjectAttachmentsResponse) {
	response = &DescribeProjectAttachmentsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
