package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPSMemberDataTypeCode invokes the ltl.ListPSMemberDataTypeCode API synchronously
func (client *Client) ListPSMemberDataTypeCode(request *ListPSMemberDataTypeCodeRequest) (response *ListPSMemberDataTypeCodeResponse, err error) {
	response = CreateListPSMemberDataTypeCodeResponse()
	err = client.DoAction(request, response)
	return
}

// ListPSMemberDataTypeCodeWithChan invokes the ltl.ListPSMemberDataTypeCode API asynchronously
func (client *Client) ListPSMemberDataTypeCodeWithChan(request *ListPSMemberDataTypeCodeRequest) (<-chan *ListPSMemberDataTypeCodeResponse, <-chan error) {
	responseChan := make(chan *ListPSMemberDataTypeCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPSMemberDataTypeCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPSMemberDataTypeCodeWithCallback invokes the ltl.ListPSMemberDataTypeCode API asynchronously
func (client *Client) ListPSMemberDataTypeCodeWithCallback(request *ListPSMemberDataTypeCodeRequest, callback func(response *ListPSMemberDataTypeCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPSMemberDataTypeCodeResponse
		var err error
		defer close(result)
		response, err = client.ListPSMemberDataTypeCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPSMemberDataTypeCodeRequest is the request struct for api ListPSMemberDataTypeCode
type ListPSMemberDataTypeCodeRequest struct {
	*requests.RpcRequest
	Size       requests.Integer `position:"Query" name:"Size"`
	MemberUid  string           `position:"Query" name:"MemberUid"`
	Num        requests.Integer `position:"Query" name:"Num"`
	ApiVersion string           `position:"Query" name:"ApiVersion"`
	BizChainId string           `position:"Query" name:"BizChainId"`
}

// ListPSMemberDataTypeCodeResponse is the response struct for api ListPSMemberDataTypeCode
type ListPSMemberDataTypeCodeResponse struct {
	*responses.BaseResponse
	Code      int                            `json:"Code" xml:"Code"`
	Message   string                         `json:"Message" xml:"Message"`
	RequestId string                         `json:"RequestId" xml:"RequestId"`
	Success   bool                           `json:"Success" xml:"Success"`
	Data      DataInListPSMemberDataTypeCode `json:"Data" xml:"Data"`
}

// CreateListPSMemberDataTypeCodeRequest creates a request to invoke ListPSMemberDataTypeCode API
func CreateListPSMemberDataTypeCodeRequest() (request *ListPSMemberDataTypeCodeRequest) {
	request = &ListPSMemberDataTypeCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "ListPSMemberDataTypeCode", "", "")
	request.Method = requests.POST
	return
}

// CreateListPSMemberDataTypeCodeResponse creates a response to parse from ListPSMemberDataTypeCode response
func CreateListPSMemberDataTypeCodeResponse() (response *ListPSMemberDataTypeCodeResponse) {
	response = &ListPSMemberDataTypeCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
